/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.string;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.streams.StreamUtils;

public class StringUtils {
    private static Properties LATIN1_ESCAPE_CHARACTERS = null;

    public static String unEscapeHTML(String sequence) {
        return StringUtils.replaceCharacters(sequence, LATIN1_ESCAPE_CHARACTERS);
    }

    public static String replaceCharacters(String sequence, Properties characterSet) {
        if (characterSet == null) {
            characterSet = LATIN1_ESCAPE_CHARACTERS;
        }
        for (Map.Entry<Object, Object> entry : characterSet.entrySet()) {
            sequence = sequence.replaceAll(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return sequence;
    }

    public static String removeHTMLTags(String sequence) {
        return sequence.replaceAll("\\<.*?>", "");
    }

    public static String parseUTF8(String encodedString) {
        return new String(encodedString.getBytes(), StandardCharsets.UTF_8);
    }

    public static boolean isValidUUID(String uuidstring) {
        try {
            UUID.fromString(uuidstring);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidURL(String urlstring) {
        try {
            new URL(urlstring);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String toQuotedCommaSeparatedString(List<? extends Object> list) {
        Object arrayString = Arrays.deepToString(list.toArray());
        arrayString = ((String)arrayString).substring(1, ((String)arrayString).length() - 1);
        arrayString = "\"" + ((String)arrayString).replaceAll(", ", "\", \"") + "\"";
        return arrayString;
    }

    public static String toQuotedCommaSeparatedString(Object[] array) {
        Object arrayString = Arrays.deepToString(array);
        arrayString = ((String)arrayString).substring(1, ((String)arrayString).length() - 1);
        arrayString = "\"" + ((String)arrayString).replaceAll(", ", "\", \"") + "\"";
        return arrayString;
    }

    public static String toCommaSeparatedString(Collection<? extends Object> list) {
        String arrayString = Arrays.deepToString(list.toArray());
        return arrayString.substring(1, arrayString.length() - 1);
    }

    public static String toCommaSeparatedString(Object[] array) {
        String arrayString = Arrays.deepToString(array);
        return arrayString.substring(1, arrayString.length() - 1);
    }

    public static String toCommaSeparatedString(List<? extends Object> list, Field field) throws IllegalArgumentException, IllegalAccessException {
        ReflectionUtils.fixFieldAccess(field);
        StringBuilder arrayString = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object value = field.get(list.get(i));
            arrayString.append(value + ",");
        }
        return arrayString.substring(0, arrayString.length() - 1);
    }

    public static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    public static String readFileAsString(File file) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    public static String readStreamAsString(InputStream inputStream) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    public static String substring(String string, int maxChars, String suffix) {
        if (string.length() > maxChars) {
            return string.substring(0, maxChars - 1) + suffix;
        }
        return string;
    }

    public static String toLogFormat(String string, int maxLength) {
        if (string != null) {
            String returnString = StringUtils.substring(string, maxLength, "...");
            return returnString.replace("\n", " ").replace("\r", " ").replace("\t", " ");
        }
        return string;
    }

    public static String toSentenceCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.toLowerCase().substring(1);
    }

    public static String toFirstLetterUppercase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String toFirstLetterLowercase(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String repeatString(String string, int repetitionCount) {
        StringBuilder stringBuilder = new StringBuilder();
        StringUtils.repeatString(string, repetitionCount, stringBuilder);
        return stringBuilder.toString();
    }

    public static void repeatString(String string, int repetitionCount, StringBuilder stringBuilder) {
        if (repetitionCount >= 1) {
            for (int i = 1; i <= repetitionCount; ++i) {
                stringBuilder.append(string);
            }
        }
    }

    public static ArrayList<String> splitOnLineBreak(String string, boolean removeDuplicates) {
        if (!StringUtils.isEmpty(string)) {
            String[] lines;
            ArrayList<String> stringList = new ArrayList<String>();
            for (String line : lines = string.split("\n")) {
                line = line.replace("\n", "");
                if (StringUtils.isEmpty(line = line.replace("\r", "")) || removeDuplicates && stringList.contains(line)) continue;
                stringList.add(line);
            }
            if (!stringList.isEmpty()) {
                return stringList;
            }
        }
        return null;
    }

    public static int countOccurrences(String string, String snippet) {
        int count = 0;
        int index = 0;
        while ((index = string.indexOf(snippet, index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }

    static {
        LATIN1_ESCAPE_CHARACTERS = new Properties();
        InputStream inputStream = StringUtils.class.getResourceAsStream("latin-1-escaped-character-set.properties");
        try {
            LATIN1_ESCAPE_CHARACTERS.load(inputStream);
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            StreamUtils.closeStream(inputStream);
        }
    }
}

