/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.HeaderDecoratorPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.annotations.security.doseta.After;
import org.jboss.resteasy.annotations.security.doseta.Signed;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
@HeaderDecoratorPrecedence
public class DigitalSigningHeaderDecorator
implements MessageBodyWriterInterceptor,
AcceptedByMethod {
    protected Signed signed;

    public boolean accept(Class declaring, Method method) {
        this.signed = method.getAnnotation(Signed.class);
        if (this.signed == null) {
            this.signed = declaring.getAnnotation(Signed.class);
        }
        return this.signed != null;
    }

    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        After after;
        DKIMSignature header = new DKIMSignature();
        KeyRepository repository = (KeyRepository)context.getAttribute(KeyRepository.class.getName());
        if (repository == null) {
            repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
        }
        if (this.signed.domain() != null && !this.signed.domain().equals("")) {
            header.setDomain(this.signed.domain());
        } else if (repository != null) {
            header.setDomain(repository.getDefaultPrivateDomain());
        }
        if (this.signed.algorithm() != null && !this.signed.algorithm().equals("")) {
            header.setAlgorithm(this.signed.algorithm());
        }
        if (this.signed.selector() != null && !this.signed.selector().equals("")) {
            header.setSelector(this.signed.selector());
        } else if (repository != null) {
            header.setSelector(repository.getDefaultPrivateSelector());
        }
        if (this.signed.timestamped()) {
            header.setTimestamp();
        }
        if ((after = this.signed.expires()).seconds() > 0 || after.minutes() > 0 || after.hours() > 0 || after.days() > 0 || after.months() > 0 || after.years() > 0) {
            header.setExpiration(after.seconds(), after.minutes(), after.hours(), after.days(), after.months(), after.years());
        }
        context.getHeaders().add((Object)"DKIM-Signature", (Object)header);
        context.proceed();
    }
}

