/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication.digest;

import dev.resteasy.client.util.authentication.digest.DigestHashBuilder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.jboss.logging.Logger;

class Algorithm {
    private static final Logger LOGGER = Logger.getLogger((String)Algorithm.class.getPackageName());
    private final String algorithm;
    private final MessageDigest md;
    private final boolean isSession;

    private Algorithm(String algorithm, MessageDigest md, boolean isSession) {
        this.algorithm = algorithm;
        this.md = md;
        this.isSession = isSession;
    }

    static Algorithm parse(String algorithm) {
        Object v = algorithm == null ? null : algorithm.toUpperCase(Locale.ROOT).trim();
        boolean session = false;
        if (v == null || ((String)v).isBlank()) {
            v = "MD5";
        } else if (((String)v).endsWith("-SESS")) {
            v = ((String)v).substring(0, ((String)v).indexOf("-SESS"));
            session = true;
        } else {
            v = algorithm;
        }
        try {
            MessageDigest md = MessageDigest.getInstance((String)v);
            return new Algorithm(algorithm, md, session);
        }
        catch (NoSuchAlgorithmException e) {
            if (((String)v).startsWith("SHA-512-")) {
                v = "SHA-512/" + ((String)v).substring(8);
            }
            try {
                MessageDigest md = MessageDigest.getInstance((String)v);
                return new Algorithm(algorithm, md, session);
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.debugf((Throwable)ex, "Failed to find digest for %s", (Object)algorithm);
                return null;
            }
        }
    }

    boolean isSession() {
        return this.isSession;
    }

    DigestHashBuilder builder() {
        return new DigestHashBuilder(this.md);
    }

    public String toString() {
        return this.algorithm;
    }
}

