/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProvider;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProviders;
import org.jboss.resteasy.microprofile.client.header.IncomingHeadersProvider;
import org.jboss.resteasy.microprofile.client.utils.ClientRequestContextUtils;
import org.jboss.resteasy.microprofile.client.utils.ListCastUtils;

@Priority(value=-2147483648)
public class ClientHeadersRequestFilter
implements ClientRequestFilter {
    private static final IncomingHeadersProvider noIncomingHeadersProvider = MultivaluedHashMap::new;
    private static final IncomingHeadersProvider incomingHeadersProvider = ClientHeadersRequestFilter.initializeProvider();

    private static IncomingHeadersProvider initializeProvider() {
        ServiceLoader<IncomingHeadersProvider> providerLoader = ServiceLoader.load(IncomingHeadersProvider.class);
        Iterator<IncomingHeadersProvider> providers = providerLoader.iterator();
        if (!providers.hasNext()) {
            return noIncomingHeadersProvider;
        }
        IncomingHeadersProvider result = providers.next();
        if (providers.hasNext()) {
            throw new RuntimeException("Multiple " + IncomingHeadersProvider.class.getCanonicalName() + "'s registered, expecting at most one.");
        }
        return result;
    }

    public void filter(ClientRequestContext requestContext) {
        Method method = ClientRequestContextUtils.getMethod(requestContext);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Optional<ClientHeaderProvider> handler = ClientHeaderProviders.getProvider(method);
        handler.ifPresent(arg_0 -> ClientHeadersRequestFilter.lambda$filter$0((MultivaluedMap)headers, arg_0));
        Optional<ClientHeadersFactory> factory = ClientHeaderProviders.getFactory(method.getDeclaringClass());
        requestContext.getHeaders().forEach((arg_0, arg_1) -> ClientHeadersRequestFilter.lambda$filter$1((MultivaluedMap)headers, arg_0, arg_1));
        factory.map(arg_0 -> this.lambda$filter$2((MultivaluedMap)headers, arg_0)).orElse((MultivaluedMap)headers).forEach((key, values) -> {
            List cfr_ignored_0 = (List)requestContext.getHeaders().put(key, ClientHeadersRequestFilter.castToListOfObjects(values));
        });
    }

    private MultivaluedMap<String, String> updateHeaders(MultivaluedMap<String, String> headers, ClientHeadersFactory factory) {
        return factory.update(incomingHeadersProvider.getIncomingHeaders(), headers);
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return new ArrayList<Object>(values);
    }

    private /* synthetic */ MultivaluedMap lambda$filter$2(MultivaluedMap headers, ClientHeadersFactory f) {
        return this.updateHeaders((MultivaluedMap<String, String>)headers, f);
    }

    private static /* synthetic */ void lambda$filter$1(MultivaluedMap headers, String key, List values) {
        List cfr_ignored_0 = (List)headers.put((Object)key, ListCastUtils.castToListOfStrings(values));
    }

    private static /* synthetic */ void lambda$filter$0(MultivaluedMap headers, ClientHeaderProvider h) {
        h.addHeaders((MultivaluedMap<String, String>)headers);
    }
}

