/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderGenerator;
import org.jboss.resteasy.microprofile.client.header.HeaderFillerFactory;

public class ClientHeaderProvider {
    private final Collection<ClientHeaderGenerator> generators;

    static Optional<ClientHeaderProvider> forMethod(Method method, Object clientProxy, HeaderFillerFactory fillerFactory) {
        Class<?> declaringClass = method.getDeclaringClass();
        ClientHeaderParam[] methodAnnotations = (ClientHeaderParam[])method.getAnnotationsByType(ClientHeaderParam.class);
        ClientHeaderParam[] classAnnotations = (ClientHeaderParam[])declaringClass.getAnnotationsByType(ClientHeaderParam.class);
        HashMap<String, ClientHeaderGenerator> generators = new HashMap<String, ClientHeaderGenerator>();
        for (ClientHeaderParam annotation : methodAnnotations) {
            if (generators.containsKey(annotation.name())) {
                throw new RestClientDefinitionException("Duplicate " + ClientHeaderParam.class.getSimpleName() + " annotation definitions found on " + method.toString());
            }
            generators.put(annotation.name(), new ClientHeaderGenerator(annotation, declaringClass, clientProxy, fillerFactory));
        }
        ClientHeaderProvider.checkForDuplicateClassLevelAnnotations(classAnnotations, declaringClass);
        Stream.of(classAnnotations).filter(a -> !generators.containsKey(a.name())).forEach(a -> generators.put(a.name(), new ClientHeaderGenerator((ClientHeaderParam)a, declaringClass, clientProxy, fillerFactory)));
        return generators.isEmpty() ? Optional.empty() : Optional.of(new ClientHeaderProvider(generators.values()));
    }

    private static void checkForDuplicateClassLevelAnnotations(ClientHeaderParam[] classAnnotations, Class<?> declaringClass) {
        HashSet headerNames = new HashSet();
        Arrays.stream(classAnnotations).map(ClientHeaderParam::name).forEach(name -> {
            if (!headerNames.add(name)) {
                throw new RestClientDefinitionException("Duplicate ClientHeaderParam definition for header name " + name + " on class " + declaringClass.getCanonicalName());
            }
        });
    }

    ClientHeaderProvider(Collection<ClientHeaderGenerator> generators) {
        this.generators = generators;
    }

    public void addHeaders(MultivaluedMap<String, String> headers) {
        this.generators.forEach(g -> g.fillHeaders(headers));
    }
}

