/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.lang.instrument.ClassFileTransformer;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.AliasModuleSpec;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.Version;

public abstract class ModuleSpec {
    private final String name;

    ModuleSpec(String name) {
        this.name = name;
    }

    @Deprecated
    public static Builder build(ModuleIdentifier moduleIdentifier) {
        return ModuleSpec.build(moduleIdentifier.toString());
    }

    public static Builder build(final String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return new Builder(){
            private String mainClass;
            private AssertionSetting assertionSetting = AssertionSetting.INHERIT;
            private final List<ResourceLoaderSpec> resourceLoaders = new ArrayList<ResourceLoaderSpec>(0);
            private final List<DependencySpec> dependencies = new ArrayList<DependencySpec>();
            private final Map<String, String> properties = new LinkedHashMap<String, String>(0);
            private LocalLoader fallbackLoader;
            private ModuleClassLoaderFactory moduleClassLoaderFactory;
            private ClassFileTransformer classFileTransformer;
            private PermissionCollection permissionCollection;
            private Version version;

            @Override
            public Builder setFallbackLoader(LocalLoader fallbackLoader) {
                this.fallbackLoader = fallbackLoader;
                return this;
            }

            @Override
            public Builder setMainClass(String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            @Override
            public Builder setAssertionSetting(AssertionSetting assertionSetting) {
                this.assertionSetting = assertionSetting == null ? AssertionSetting.INHERIT : assertionSetting;
                return this;
            }

            @Override
            public Builder addDependency(DependencySpec dependencySpec) {
                this.dependencies.add(dependencySpec);
                return this;
            }

            @Override
            public Builder addResourceRoot(ResourceLoaderSpec resourceLoader) {
                this.resourceLoaders.add(resourceLoader);
                return this;
            }

            @Override
            public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory moduleClassLoaderFactory) {
                this.moduleClassLoaderFactory = moduleClassLoaderFactory;
                return this;
            }

            @Override
            public Builder setClassFileTransformer(ClassFileTransformer classFileTransformer) {
                this.classFileTransformer = classFileTransformer;
                return this;
            }

            @Override
            public Builder addProperty(String name2, String value) {
                this.properties.put(name2, value);
                return this;
            }

            @Override
            public Builder setPermissionCollection(PermissionCollection permissionCollection) {
                this.permissionCollection = permissionCollection;
                return this;
            }

            @Override
            public Builder setVersion(Version version) {
                this.version = version;
                return this;
            }

            @Override
            public ModuleSpec create() {
                return new ConcreteModuleSpec(name, this.mainClass, this.assertionSetting, this.resourceLoaders.toArray(new ResourceLoaderSpec[this.resourceLoaders.size()]), this.dependencies.toArray(new DependencySpec[this.dependencies.size()]), this.fallbackLoader, this.moduleClassLoaderFactory, this.classFileTransformer, this.properties, this.permissionCollection, this.version);
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    @Deprecated
    public static AliasBuilder buildAlias(ModuleIdentifier moduleIdentifier, ModuleIdentifier aliasTarget) {
        return ModuleSpec.buildAlias(moduleIdentifier.toString(), aliasTarget.toString());
    }

    public static AliasBuilder buildAlias(final String name, final String aliasName) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (aliasName == null) {
            throw new IllegalArgumentException("aliasName is null");
        }
        return new AliasBuilder(){

            @Override
            public ModuleSpec create() {
                return new AliasModuleSpec(name, aliasName);
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getAliasName() {
                return null;
            }
        };
    }

    public ModuleIdentifier getModuleIdentifier() {
        return ModuleIdentifier.fromString(this.name);
    }

    public String getName() {
        return this.name;
    }

    public static interface AliasBuilder {
        public ModuleSpec create();

        @Deprecated
        default public ModuleIdentifier getIdentifier() {
            return ModuleIdentifier.fromString(this.getName());
        }

        public String getName();

        @Deprecated
        default public ModuleIdentifier getAliasTarget() {
            return ModuleIdentifier.fromString(this.getAliasName());
        }

        public String getAliasName();
    }

    public static interface Builder {
        public Builder setMainClass(String var1);

        public Builder setAssertionSetting(AssertionSetting var1);

        public Builder addDependency(DependencySpec var1);

        public Builder addResourceRoot(ResourceLoaderSpec var1);

        public ModuleSpec create();

        @Deprecated
        default public ModuleIdentifier getIdentifier() {
            return ModuleIdentifier.fromString(this.getName());
        }

        public String getName();

        public Builder setFallbackLoader(LocalLoader var1);

        public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory var1);

        public Builder setClassFileTransformer(ClassFileTransformer var1);

        public Builder addProperty(String var1, String var2);

        public Builder setPermissionCollection(PermissionCollection var1);

        public Builder setVersion(Version var1);
    }
}

