/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.FileResourceLoader;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.MavenArtifactUtil;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModulesPolicy;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.StreamUtil;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.security.FactoryPermissionCollection;
import org.jboss.modules.security.ModularPermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.modules.xml.MXParser;
import org.jboss.modules.xml.XmlPullParser;
import org.jboss.modules.xml.XmlPullParserException;

final class ModuleXmlParser {
    private static final String MODULE_1_0 = "urn:jboss:module:1.0";
    private static final String MODULE_1_1 = "urn:jboss:module:1.1";
    private static final String MODULE_1_2 = "urn:jboss:module:1.2";
    private static final String MODULE_1_3 = "urn:jboss:module:1.3";
    private static final String E_MODULE = "module";
    private static final String E_ARTIFACT = "artifact";
    private static final String E_NATIVE_ARTIFACT = "native-artifact";
    private static final String E_DEPENDENCIES = "dependencies";
    private static final String E_RESOURCES = "resources";
    private static final String E_MAIN_CLASS = "main-class";
    private static final String E_RESOURCE_ROOT = "resource-root";
    private static final String E_PATH = "path";
    private static final String E_EXPORTS = "exports";
    private static final String E_IMPORTS = "imports";
    private static final String E_INCLUDE = "include";
    private static final String E_EXCLUDE = "exclude";
    private static final String E_INCLUDE_SET = "include-set";
    private static final String E_EXCLUDE_SET = "exclude-set";
    private static final String E_FILTER = "filter";
    private static final String E_SYSTEM = "system";
    private static final String E_PATHS = "paths";
    private static final String E_MODULE_ALIAS = "module-alias";
    private static final String E_MODULE_ABSENT = "module-absent";
    private static final String E_PROPERTIES = "properties";
    private static final String E_PROPERTY = "property";
    private static final String E_PERMISSIONS = "permissions";
    private static final String E_GRANT = "grant";
    private static final String A_NAME = "name";
    private static final String A_SLOT = "slot";
    private static final String A_EXPORT = "export";
    private static final String A_SERVICES = "services";
    private static final String A_PATH = "path";
    private static final String A_OPTIONAL = "optional";
    private static final String A_TARGET_NAME = "target-name";
    private static final String A_TARGET_SLOT = "target-slot";
    private static final String A_VALUE = "value";
    private static final String A_PERMISSION = "permission";
    private static final String A_ACTIONS = "actions";
    private static final String D_NONE = "none";
    private static final String D_IMPORT = "import";
    private static final String D_EXPORT = "export";

    private ModuleXmlParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleSpec parseModuleXml(ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier, File root, File moduleInfoFile, final AccessControlContext context) throws ModuleLoadException, IOException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(moduleInfoFile);
        }
        catch (FileNotFoundException e) {
            throw new ModuleLoadException("No module.xml file found at " + moduleInfoFile);
        }
        try {
            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleXml(new ResourceRootFactory(){

                @Override
                public ResourceLoader createResourceLoader(String rootPath, String loaderPath, String loaderName) throws IOException {
                    File file = new File(rootPath, loaderPath);
                    if (file.isDirectory()) {
                        return new FileResourceLoader(loaderName, file, context);
                    }
                    JarFile jarFile = new JarFile(file, true);
                    return new JarFileResourceLoader(loaderName, jarFile);
                }
            }, root.getPath(), new BufferedInputStream(fis), moduleInfoFile.getPath(), moduleLoader, moduleIdentifier);
            return moduleSpec;
        }
        finally {
            StreamUtil.safeClose(fis);
        }
    }

    static ModuleSpec parseModuleXml(ResourceRootFactory factory, String rootPath, InputStream source, String moduleInfoFile, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) throws ModuleLoadException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(source, null);
            ModuleSpec moduleSpec = ModuleXmlParser.parseDocument(factory, rootPath, parser, moduleLoader, moduleIdentifier);
            return moduleSpec;
        }
        catch (XmlPullParserException e) {
            throw new ModuleLoadException("Error loading module from " + moduleInfoFile, e);
        }
        finally {
            StreamUtil.safeClose(source);
        }
    }

    protected static XmlPullParserException unexpectedContent(XmlPullParser reader) {
        String kind;
        switch (reader.getEventType()) {
            case 5: {
                kind = "cdata";
                break;
            }
            case 9: {
                kind = "comment";
                break;
            }
            case 10: {
                kind = "document decl";
                break;
            }
            case 1: {
                kind = "document end";
                break;
            }
            case 3: {
                kind = "element end";
                break;
            }
            case 6: {
                kind = "entity ref";
                break;
            }
            case 8: {
                kind = "processing instruction";
                break;
            }
            case 7: {
                kind = "whitespace";
                break;
            }
            case 0: {
                kind = "document start";
                break;
            }
            case 2: {
                kind = "element start";
                break;
            }
            case 4: {
                kind = "text";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.getName() != null) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.getText() != null) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XmlPullParserException(b.toString(), reader, null);
    }

    protected static XmlPullParserException endOfDocument(XmlPullParser reader) {
        return new XmlPullParserException("Unexpected end of document", reader, null);
    }

    private static XmlPullParserException invalidModuleName(XmlPullParser reader, ModuleIdentifier expected) {
        return new XmlPullParserException("Invalid/mismatched module name (expected " + expected + ")", reader, null);
    }

    private static XmlPullParserException missingAttributes(XmlPullParser reader, Set<String> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (String attribute : required) {
            b.append(' ').append(attribute);
        }
        return new XmlPullParserException(b.toString(), reader, null);
    }

    private static XmlPullParserException unknownAttribute(XmlPullParser parser, int index) {
        String namespace = parser.getAttributeNamespace(index);
        String prefix = parser.getAttributePrefix(index);
        String name = parser.getAttributeName(index);
        StringBuilder eb = new StringBuilder("Unknown attribute \"");
        if (prefix != null) {
            eb.append(prefix).append(':');
        }
        eb.append(name);
        if (namespace != null) {
            eb.append("\" from namespace \"").append(namespace);
        }
        eb.append('\"');
        return new XmlPullParserException(eb.toString(), parser, null);
    }

    private static XmlPullParserException unknownAttributeValue(XmlPullParser parser, int index) {
        String namespace = parser.getAttributeNamespace(index);
        String prefix = parser.getAttributePrefix(index);
        String name = parser.getAttributeName(index);
        StringBuilder eb = new StringBuilder("Unknown value \"");
        eb.append(parser.getAttributeValue(index));
        eb.append("\" for attribute \"");
        if (prefix != null && !prefix.isEmpty()) {
            eb.append(prefix).append(':');
        }
        eb.append(name);
        if (namespace != null && !namespace.isEmpty()) {
            eb.append("\" from namespace \"").append(namespace);
        }
        eb.append('\"');
        return new XmlPullParserException(eb.toString(), parser, null);
    }

    private static void validateNamespace(XmlPullParser reader) throws XmlPullParserException {
        String string = reader.getNamespace();
        int n = -1;
        switch (string.hashCode()) {
            case 220221201: {
                if (!string.equals(MODULE_1_0)) break;
                n = 0;
                break;
            }
            case 220221202: {
                if (!string.equals(MODULE_1_1)) break;
                n = 1;
                break;
            }
            case 220221203: {
                if (!string.equals(MODULE_1_2)) break;
                n = 2;
                break;
            }
            case 220221204: {
                if (!string.equals(MODULE_1_3)) break;
                n = 3;
            }
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw ModuleXmlParser.unexpectedContent(reader);
            }
        }
    }

    private static void assertNoAttributes(XmlPullParser reader) throws XmlPullParserException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw ModuleXmlParser.unknownAttribute(reader, 0);
        }
    }

    private static void validateAttributeNamespace(XmlPullParser reader, int index) throws XmlPullParserException {
        if (!reader.getAttributeNamespace(index).isEmpty()) {
            throw ModuleXmlParser.unknownAttribute(reader, index);
        }
    }

    private static ModuleSpec parseDocument(ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) throws XmlPullParserException, IOException {
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 0: {
                    return ModuleXmlParser.parseRootElement(factory, rootPath, reader, moduleLoader, moduleIdentifier);
                }
                case 2: {
                    String element;
                    String string = element = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1068784020: {
                            if (!string.equals(E_MODULE)) break;
                            n = 0;
                            break;
                        }
                        case 166449071: {
                            if (!string.equals(E_MODULE_ALIAS)) break;
                            n = 1;
                            break;
                        }
                        case 856020410: {
                            if (!string.equals(E_MODULE_ABSENT)) break;
                            n = 2;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleSpec.Builder specBuilder = ModuleSpec.build(moduleIdentifier);
                            ModuleXmlParser.parseModuleContents(reader, factory, moduleLoader, moduleIdentifier, specBuilder, rootPath);
                            ModuleXmlParser.parseEndDocument(reader);
                            return specBuilder.create();
                        }
                        case 1: {
                            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleAliasContents(reader, moduleIdentifier);
                            ModuleXmlParser.parseEndDocument(reader);
                            return moduleSpec;
                        }
                        case 2: {
                            ModuleXmlParser.parseModuleAbsentContents(reader, moduleIdentifier);
                            return null;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static ModuleSpec parseRootElement(ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String element;
                    ModuleXmlParser.validateNamespace(reader);
                    String string = element = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1068784020: {
                            if (!string.equals(E_MODULE)) break;
                            n = 0;
                            break;
                        }
                        case 166449071: {
                            if (!string.equals(E_MODULE_ALIAS)) break;
                            n = 1;
                            break;
                        }
                        case 856020410: {
                            if (!string.equals(E_MODULE_ABSENT)) break;
                            n = 2;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleSpec.Builder specBuilder = ModuleSpec.build(moduleIdentifier);
                            ModuleXmlParser.parseModuleContents(reader, factory, moduleLoader, moduleIdentifier, specBuilder, rootPath);
                            ModuleXmlParser.parseEndDocument(reader);
                            return specBuilder.create();
                        }
                        case 1: {
                            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleAliasContents(reader, moduleIdentifier);
                            ModuleXmlParser.parseEndDocument(reader);
                            return moduleSpec;
                        }
                        case 2: {
                            ModuleXmlParser.parseModuleAbsentContents(reader, moduleIdentifier);
                            return null;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static ModuleSpec parseModuleAliasContents(XmlPullParser reader, ModuleIdentifier moduleIdentifier) throws XmlPullParserException, IOException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        String targetName = null;
        String targetSlot = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME, A_TARGET_NAME));
        block15: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                    break;
                }
                case 3533310: {
                    if (!string.equals(A_SLOT)) break;
                    n = 1;
                    break;
                }
                case -2130936505: {
                    if (!string.equals(A_TARGET_NAME)) break;
                    n = 2;
                    break;
                }
                case -2130776902: {
                    if (!string.equals(A_TARGET_SLOT)) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block15;
                }
                case 1: {
                    slot = reader.getAttributeValue(i);
                    continue block15;
                }
                case 2: {
                    targetName = reader.getAttributeValue(i);
                    continue block15;
                }
                case 3: {
                    targetSlot = reader.getAttributeValue(i);
                    continue block15;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (!moduleIdentifier.equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader, moduleIdentifier);
        }
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 3: {
                    return ModuleSpec.buildAlias(moduleIdentifier, ModuleIdentifier.create(targetName, targetSlot)).create();
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parseModuleAbsentContents(XmlPullParser reader, ModuleIdentifier moduleIdentifier) throws XmlPullParserException, IOException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME, A_SLOT));
        block11: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                    break;
                }
                case 3533310: {
                    if (!string.equals(A_SLOT)) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block11;
                }
                case 1: {
                    slot = reader.getAttributeValue(i);
                    continue block11;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (!moduleIdentifier.equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader, moduleIdentifier);
        }
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parseModuleContents(XmlPullParser reader, ResourceRootFactory factory, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier, ModuleSpec.Builder specBuilder, String rootPath) throws XmlPullParserException, IOException {
        int eventType;
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        block28: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                    break;
                }
                case 3533310: {
                    if (!string.equals(A_SLOT)) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block28;
                }
                case 1: {
                    slot = reader.getAttributeValue(i);
                    continue block28;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (!specBuilder.getIdentifier().equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader, specBuilder.getIdentifier());
        }
        MultiplePathFilterBuilder exportsBuilder = PathFilters.multiplePathFilterBuilder(true);
        HashSet<String> visited = new HashSet<String>();
        boolean gotPerms = false;
        block29: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    if (!gotPerms) {
                        specBuilder.setPermissionCollection(ModulesPolicy.DEFAULT_PERMISSION_COLLECTION);
                    }
                    specBuilder.addDependency(DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), exportsBuilder.create()));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String element = reader.getName();
                    if (visited.contains(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    visited.add(element);
                    String string = element;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1309056193: {
                            if (!string.equals(E_EXPORTS)) break;
                            n = 0;
                            break;
                        }
                        case 503774505: {
                            if (!string.equals(E_DEPENDENCIES)) break;
                            n = 1;
                            break;
                        }
                        case -638856092: {
                            if (!string.equals(E_MAIN_CLASS)) break;
                            n = 2;
                            break;
                        }
                        case -1983070683: {
                            if (!string.equals(E_RESOURCES)) break;
                            n = 3;
                            break;
                        }
                        case -926053069: {
                            if (!string.equals(E_PROPERTIES)) break;
                            n = 4;
                            break;
                        }
                        case 1133704324: {
                            if (!string.equals(E_PERMISSIONS)) break;
                            n = 5;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parseFilterList(reader, exportsBuilder);
                            continue block29;
                        }
                        case 1: {
                            ModuleXmlParser.parseDependencies(reader, specBuilder);
                            continue block29;
                        }
                        case 2: {
                            ModuleXmlParser.parseMainClass(reader, specBuilder);
                            continue block29;
                        }
                        case 3: {
                            ModuleXmlParser.parseResources(factory, rootPath, reader, specBuilder);
                            continue block29;
                        }
                        case 4: {
                            ModuleXmlParser.parseProperties(reader, specBuilder);
                            continue block29;
                        }
                        case 5: {
                            ModuleXmlParser.parsePermissions(reader, moduleLoader, moduleIdentifier, specBuilder);
                            gotPerms = true;
                            continue block29;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parseDependencies(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        int eventType;
        ModuleXmlParser.assertNoAttributes(reader);
        block12: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1068784020: {
                            if (!string.equals(E_MODULE)) break;
                            n = 0;
                            break;
                        }
                        case -887328209: {
                            if (!string.equals(E_SYSTEM)) break;
                            n = 1;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parseModuleDependency(reader, specBuilder);
                            continue block12;
                        }
                        case 1: {
                            ModuleXmlParser.parseSystemDependency(reader, specBuilder);
                            continue block12;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parseModuleDependency(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        int eventType;
        String name = null;
        String slot = null;
        boolean export = false;
        boolean optional = false;
        String services = D_NONE;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        int count = reader.getAttributeCount();
        block34: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                    break;
                }
                case 3533310: {
                    if (!string.equals(A_SLOT)) break;
                    n = 1;
                    break;
                }
                case -1289153612: {
                    if (!string.equals("export")) break;
                    n = 2;
                    break;
                }
                case -79017120: {
                    if (!string.equals(A_OPTIONAL)) break;
                    n = 3;
                    break;
                }
                case 1379209310: {
                    if (!string.equals(A_SERVICES)) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block34;
                }
                case 1: {
                    slot = reader.getAttributeValue(i);
                    continue block34;
                }
                case 2: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block34;
                }
                case 3: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block34;
                }
                case 4: {
                    String string2 = services = reader.getAttributeValue(i);
                    int n2 = -1;
                    switch (string2.hashCode()) {
                        case 3387192: {
                            if (!string2.equals(D_NONE)) break;
                            n2 = 0;
                            break;
                        }
                        case -1184795739: {
                            if (!string2.equals(D_IMPORT)) break;
                            n2 = 1;
                            break;
                        }
                        case -1289153612: {
                            if (!string2.equals("export")) break;
                            n2 = 2;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: {
                            continue block34;
                        }
                    }
                    throw ModuleXmlParser.unknownAttributeValue(reader, i);
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        MultiplePathFilterBuilder importBuilder = PathFilters.multiplePathFilterBuilder(true);
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder(export);
        block35: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    PathFilter importFilter;
                    assert (services.equals(D_NONE) || services.equals("export") || services.equals(D_IMPORT));
                    if (services.equals("export")) {
                        exportBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                    }
                    if (export) {
                        exportBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        exportBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    PathFilter exportFilter = exportBuilder.create();
                    if (importBuilder.isEmpty()) {
                        importFilter = services.equals(D_NONE) ? PathFilters.getDefaultImportFilter() : PathFilters.getDefaultImportFilterWithServices();
                    } else {
                        if (!services.equals(D_NONE)) {
                            importBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                        }
                        importBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        importBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                        importFilter = importBuilder.create();
                    }
                    specBuilder.addDependency(DependencySpec.createModuleDependencySpec(importFilter, exportFilter, null, ModuleIdentifier.create(name, slot), optional));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1309056193: {
                            if (!string.equals(E_EXPORTS)) break;
                            n = 0;
                            break;
                        }
                        case 1926037870: {
                            if (!string.equals(E_IMPORTS)) break;
                            n = 1;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parseFilterList(reader, exportBuilder);
                            continue block35;
                        }
                        case 1: {
                            ModuleXmlParser.parseFilterList(reader, importBuilder);
                            continue block35;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseSystemDependency(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        int eventType;
        boolean export = false;
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            String attribute;
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String string = attribute = reader.getAttributeName(i);
            int n = -1;
            switch (string.hashCode()) {
                case -1289153612: {
                    if (!string.equals("export")) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block18;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        Set<String> paths = Collections.emptySet();
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder(export);
        while ((eventType = reader.nextTag()) != 1) {
            block6 : switch (eventType) {
                case 3: {
                    PathFilter exportFilter = exportBuilder.create();
                    specBuilder.addDependency(DependencySpec.createSystemDependencySpec(PathFilters.acceptAll(), exportFilter, paths));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case 106438894: {
                            if (!string.equals(E_PATHS)) break;
                            n = 0;
                            break;
                        }
                        case -1309056193: {
                            if (!string.equals(E_EXPORTS)) break;
                            n = 1;
                        }
                    }
                    switch (n) {
                        case 0: {
                            paths = ModuleXmlParser.parseSet(reader);
                            break block6;
                        }
                        case 1: {
                            ModuleXmlParser.parseFilterList(reader, exportBuilder);
                            break block6;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
    }

    private static void parseMainClass(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        specBuilder.setMainClass(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseResources(ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        int eventType;
        ModuleXmlParser.assertNoAttributes(reader);
        block14: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    specBuilder.addResourceRoot(new ResourceLoaderSpec(new NativeLibraryResourceLoader(new File(rootPath, "lib")), PathFilters.rejectAll()));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case 933377857: {
                            if (!string.equals(E_RESOURCE_ROOT)) break;
                            n = 0;
                            break;
                        }
                        case -1228798510: {
                            if (!string.equals(E_ARTIFACT)) break;
                            n = 1;
                            break;
                        }
                        case 901407432: {
                            if (!string.equals(E_NATIVE_ARTIFACT)) break;
                            n = 2;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parseResourceRoot(factory, rootPath, reader, specBuilder);
                            continue block14;
                        }
                        case 1: {
                            ModuleXmlParser.parseArtifact(reader, specBuilder);
                            continue block14;
                        }
                        case 2: {
                            ModuleXmlParser.parseNativeArtifact(reader, specBuilder);
                            continue block14;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    static ResourceLoader createMavenArtifactLoader(String name) throws IOException {
        File fp = MavenArtifactUtil.resolveJarArtifact(name);
        if (fp == null) {
            return null;
        }
        JarFile jarFile = new JarFile(fp, true);
        return new JarFileResourceLoader(name, jarFile);
    }

    static void createMavenNativeArtifactLoader(String name, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws IOException, XmlPullParserException {
        File fp = MavenArtifactUtil.resolveJarArtifact(name);
        if (fp == null) {
            throw new XmlPullParserException(String.format("Failed to resolve native artifact '%s'", name), reader, null);
        }
        File lib = new File(fp.getParentFile(), "lib");
        if (!lib.exists()) {
            if (!fp.getParentFile().canWrite()) {
                throw new XmlPullParserException(String.format("Native artifact '%s' cannot be unpacked", name), reader, null);
            }
            StreamUtil.unzip(fp, fp.getParentFile());
        }
        specBuilder.addResourceRoot(new ResourceLoaderSpec(new NativeLibraryResourceLoader(lib), PathFilters.rejectAll()));
    }

    private static void parseNativeArtifact(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block12;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 3: {
                    try {
                        ModuleXmlParser.createMavenNativeArtifactLoader(name, reader, specBuilder);
                    }
                    catch (IOException e) {
                        throw new XmlPullParserException(String.format("Failed to add artifact '%s'", name), reader, e);
                    }
                    return;
                }
                case 2: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseArtifact(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block12;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 3: {
                    ResourceLoader resourceLoader;
                    try {
                        resourceLoader = ModuleXmlParser.createMavenArtifactLoader(name);
                    }
                    catch (IOException e) {
                        throw new XmlPullParserException(String.format("Failed to add artifact '%s'", name), reader, e);
                    }
                    if (resourceLoader == null) {
                        throw new XmlPullParserException(String.format("Failed to resolve artifact '%s'", name), reader, null);
                    }
                    specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(resourceLoader));
                    return;
                }
                case 2: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseResourceRoot(ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        int eventType;
        String name = null;
        String path = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList("path"));
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                    break;
                }
                case 3433509: {
                    if (!string.equals("path")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block20;
                }
                case 1: {
                    path = reader.getAttributeValue(i);
                    continue block20;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (name == null) {
            name = path;
        }
        MultiplePathFilterBuilder filterBuilder = PathFilters.multiplePathFilterBuilder(true);
        HashSet<String> encountered = new HashSet<String>();
        block21: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    ResourceLoader resourceLoader;
                    try {
                        resourceLoader = factory.createResourceLoader(rootPath, path, name);
                    }
                    catch (IOException e) {
                        throw new XmlPullParserException(String.format("Failed to add resource root '%s' at path '%s'", name, path), reader, e);
                    }
                    specBuilder.addResourceRoot(new ResourceLoaderSpec(resourceLoader, filterBuilder.create()));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String element = reader.getName();
                    if (!encountered.add(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    String string = element;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1274492040: {
                            if (!string.equals(E_FILTER)) break;
                            n = 0;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parseFilterList(reader, filterBuilder);
                            continue block21;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseFilterList(XmlPullParser reader, MultiplePathFilterBuilder builder) throws XmlPullParserException, IOException {
        int eventType;
        ModuleXmlParser.assertNoAttributes(reader);
        block16: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1942574248: {
                            if (!string.equals(E_INCLUDE)) break;
                            n = 0;
                            break;
                        }
                        case -1321148966: {
                            if (!string.equals(E_EXCLUDE)) break;
                            n = 1;
                            break;
                        }
                        case 274002365: {
                            if (!string.equals(E_INCLUDE_SET)) break;
                            n = 2;
                            break;
                        }
                        case 1201705455: {
                            if (!string.equals(E_EXCLUDE_SET)) break;
                            n = 3;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parsePath(reader, true, builder);
                            continue block16;
                        }
                        case 1: {
                            ModuleXmlParser.parsePath(reader, false, builder);
                            continue block16;
                        }
                        case 2: {
                            ModuleXmlParser.parseSet(reader, true, builder);
                            continue block16;
                        }
                        case 3: {
                            ModuleXmlParser.parseSet(reader, false, builder);
                            continue block16;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parsePath(XmlPullParser reader, boolean include, MultiplePathFilterBuilder builder) throws XmlPullParserException, IOException {
        boolean literal;
        String path = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList("path"));
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3433509: {
                    if (!string.equals("path")) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    path = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                builder.addFilter(PathFilters.isChildOf(path), include);
            } else {
                builder.addFilter(PathFilters.is(path), include);
            }
        } else {
            builder.addFilter(PathFilters.match(path), include);
        }
        ModuleXmlParser.parseNoContent(reader);
    }

    private static Set<String> parseSet(XmlPullParser reader) throws XmlPullParserException, IOException {
        int eventType;
        ModuleXmlParser.assertNoAttributes(reader);
        FastCopyHashSet<String> set = new FastCopyHashSet<String>();
        while ((eventType = reader.nextTag()) != 1) {
            block0 : switch (eventType) {
                case 3: {
                    return set;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case 3433509: {
                            if (!string.equals("path")) break;
                            n = 0;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parsePathName(reader, set);
                            break block0;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        return set;
    }

    private static void parseSet(XmlPullParser reader, boolean include, MultiplePathFilterBuilder builder) throws XmlPullParserException, IOException {
        builder.addFilter(PathFilters.in(ModuleXmlParser.parseSet(reader)), include);
    }

    private static void parsePathName(XmlPullParser reader, Set<String> set) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        set.add(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseProperties(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        int eventType;
        ModuleXmlParser.assertNoAttributes(reader);
        block10: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case -993141291: {
                            if (!string.equals(E_PROPERTY)) break;
                            n = 0;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parseProperty(reader, specBuilder);
                            continue block10;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parseProperty(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        String value = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 0;
                    break;
                }
                case 111972721: {
                    if (!string.equals(A_VALUE)) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                case 1: {
                    value = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        specBuilder.addProperty(name, value == null ? "true" : value);
        if ("jboss.assertions".equals(name)) {
            try {
                specBuilder.setAssertionSetting(AssertionSetting.valueOf(value.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parsePermissions(XmlPullParser reader, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        int eventType;
        ModuleXmlParser.assertNoAttributes(reader);
        ArrayList<PermissionFactory> list = new ArrayList<PermissionFactory>();
        block10: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    specBuilder.setPermissionCollection(new FactoryPermissionCollection(list.toArray(new PermissionFactory[list.size()])));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String string = reader.getName();
                    int n = -1;
                    switch (string.hashCode()) {
                        case 98615580: {
                            if (!string.equals(E_GRANT)) break;
                            n = 0;
                        }
                    }
                    switch (n) {
                        case 0: {
                            ModuleXmlParser.parseGrant(reader, moduleLoader, moduleIdentifier, list);
                            continue block10;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parseGrant(XmlPullParser reader, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier, ArrayList<PermissionFactory> list) throws XmlPullParserException, IOException {
        String permission = null;
        String name = null;
        String actions = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_PERMISSION, A_NAME));
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            String string = attribute;
            int n = -1;
            switch (string.hashCode()) {
                case -517618225: {
                    if (!string.equals(A_PERMISSION)) break;
                    n = 0;
                    break;
                }
                case 3373707: {
                    if (!string.equals(A_NAME)) break;
                    n = 1;
                    break;
                }
                case -1161803523: {
                    if (!string.equals(A_ACTIONS)) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    permission = reader.getAttributeValue(i);
                    continue block10;
                }
                case 1: {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                case 2: {
                    actions = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        list.add(new ModularPermissionFactory(moduleLoader, moduleIdentifier, permission, name, actions));
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseNoContent(XmlPullParser reader) throws XmlPullParserException, IOException {
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    static void parseEndDocument(XmlPullParser reader) throws XmlPullParserException, IOException {
        int eventType;
        block5: while ((eventType = reader.nextToken()) != 1) {
            switch (eventType) {
                case 1: {
                    return;
                }
                case 4: 
                case 5: {
                    if (reader.isWhitespace()) continue block5;
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 7: 
                case 9: {
                    continue block5;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    static interface ResourceRootFactory {
        public ResourceLoader createResourceLoader(String var1, String var2, String var3) throws IOException;
    }
}

