/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.security.AccessController;
import java.util.Locale;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.PropertyReadAction;

public class NativeLibraryResourceLoader
extends AbstractResourceLoader {
    private static final String ARCH_NAME;
    private final File root;

    public NativeLibraryResourceLoader(File root) {
        this.root = root;
    }

    @Override
    public String getLibrary(String name) {
        File file = new File(this.root, ARCH_NAME + File.separatorChar + System.mapLibraryName(name));
        return file.exists() ? file.getAbsolutePath() : null;
    }

    public File getRoot() {
        return this.root;
    }

    public static String getArchName() {
        return ARCH_NAME;
    }

    static {
        String sysArch;
        String sysName;
        PropertyReadAction osNameReadAction = new PropertyReadAction("os.name");
        PropertyReadAction osArchReadAction = new PropertyReadAction("os.arch");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sysName = AccessController.doPrivileged(osNameReadAction).toUpperCase(Locale.US);
            sysArch = AccessController.doPrivileged(osArchReadAction).toUpperCase(Locale.US);
        } else {
            sysName = osNameReadAction.run().toUpperCase(Locale.US);
            sysArch = osArchReadAction.run().toUpperCase(Locale.US);
        }
        String realName = sysName.startsWith("LINUX") ? "linux" : (sysName.startsWith("MAC OS") ? "macosx" : (sysName.startsWith("WINDOWS") ? "win" : (sysName.startsWith("OS/2") ? "os2" : (sysName.startsWith("SOLARIS") || sysName.startsWith("SUNOS") ? "solaris" : (sysName.startsWith("MPE/IX") ? "mpeix" : (sysName.startsWith("HP-UX") ? "hpux" : (sysName.startsWith("AIX") ? "aix" : (sysName.startsWith("OS/390") ? "os390" : (sysName.startsWith("FREEBSD") ? "freebsd" : (sysName.startsWith("OPENBSD") ? "openbsd" : (sysName.startsWith("NETBSD") ? "netbsd" : (sysName.startsWith("IRIX") ? "irix" : (sysName.startsWith("DIGITAL UNIX") ? "digitalunix" : (sysName.startsWith("OSF1") ? "osf1" : (sysName.startsWith("OPENVMS") ? "openvms" : "unknown")))))))))))))));
        String realArch = sysArch.startsWith("SPARCV9") || sysArch.startsWith("SPARC64") ? "sparcv9" : (sysArch.startsWith("SPARC") ? "sparc" : (sysArch.startsWith("X86_64") || sysArch.startsWith("AMD64") ? "x86_64" : (sysArch.startsWith("I386") || sysArch.startsWith("I586") || sysArch.startsWith("I686") || sysArch.startsWith("X86") ? "i686" : (sysArch.startsWith("X32") ? "x32" : (sysArch.startsWith("PPC64") ? "ppc64" : (sysArch.startsWith("PPC") || sysArch.startsWith("POWER") ? "ppc" : (sysArch.startsWith("ARM") ? "arm" : (sysArch.startsWith("AARCH64") || sysArch.startsWith("ARM64") ? "aarch64" : (sysArch.startsWith("PA_RISC2.0W") ? "parisc64" : (sysArch.startsWith("PA_RISC") || sysArch.startsWith("PA-RISC") ? "parisc" : (sysArch.startsWith("IA64") ? sysArch.toLowerCase(Locale.US) : (sysArch.startsWith("ALPHA") ? "alpha" : (sysArch.startsWith("MIPS") ? "mips" : "unknown")))))))))))));
        ARCH_NAME = realName + "-" + realArch;
    }
}

