/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;

final class DataURLStreamHandler
extends URLStreamHandler {
    private static final DataURLStreamHandler INSTANCE = new DataURLStreamHandler();

    static DataURLStreamHandler getInstance() {
        return INSTANCE;
    }

    private DataURLStreamHandler() {
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new DataURLConnection(url);
    }

    static final class DataURLConnection
    extends URLConnection {
        private static final int ST_INITIAL = 0;
        private static final int ST_TYPE = 1;
        private static final int ST_SUBTYPE = 2;
        private static final int ST_PARAMETER = 3;
        private static final int ST_PARAMETER_VAL = 4;
        private final byte[] content;
        private final String contentString;
        private final String contentType;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        DataURLConnection(URL url) throws IOException {
            super(url);
            String str;
            byte[] bytes;
            String urlString = url.toString();
            if (!urlString.startsWith("data:")) {
                throw new ProtocolException("Wrong URL scheme");
            }
            String contentType = "text/plain";
            StringBuilder contentTypeBuilder = null;
            int state = 0;
            int len = urlString.length();
            int postCt = -1;
            int content = -1;
            int paramStart = -1;
            int paramEnd = -1;
            boolean base64 = false;
            String charsetName = null;
            boolean text = true;
            Charset charset = StandardCharsets.US_ASCII;
            int i = 5;
            while (i < len) {
                block40: {
                    int cp;
                    block43: {
                        block42: {
                            block41: {
                                cp = urlString.codePointAt(i);
                                if (state != 0) break block41;
                                if (DataURLConnection.isCTToken(cp)) {
                                    state = 1;
                                    contentTypeBuilder = new StringBuilder();
                                    contentTypeBuilder.appendCodePoint(Character.toLowerCase(cp));
                                    break block40;
                                } else if (cp == 59) {
                                    contentTypeBuilder = new StringBuilder();
                                    contentTypeBuilder.append("text/plain");
                                    postCt = contentTypeBuilder.length();
                                    paramStart = urlString.offsetByCodePoints(i, 1);
                                    state = 3;
                                    break block40;
                                } else {
                                    if (cp != 44) {
                                        throw DataURLConnection.invalidChar(i);
                                    }
                                    content = urlString.offsetByCodePoints(i, 1);
                                    break;
                                }
                            }
                            if (state != true) break block42;
                            if (DataURLConnection.isCTToken(cp)) {
                                contentTypeBuilder.appendCodePoint(Character.toLowerCase(cp));
                                break block40;
                            } else {
                                if (cp != 47) {
                                    throw DataURLConnection.invalidChar(i);
                                }
                                state = 2;
                                contentTypeBuilder.append('/');
                            }
                            break block40;
                        }
                        if (state != 2) break block43;
                        if (DataURLConnection.isCTToken(cp)) {
                            contentTypeBuilder.appendCodePoint(Character.toLowerCase(cp));
                            break block40;
                        } else if (cp == 59) {
                            postCt = contentTypeBuilder.length();
                            paramStart = urlString.offsetByCodePoints(i, 1);
                            state = 3;
                            break block40;
                        } else {
                            if (cp != 44) {
                                throw DataURLConnection.invalidChar(i);
                            }
                            contentType = contentTypeBuilder.toString();
                            text = contentType.startsWith("text/");
                            content = urlString.offsetByCodePoints(i, 1);
                            break;
                        }
                    }
                    if (state == 3) {
                        if (!DataURLConnection.isCTToken(cp)) {
                            if (cp == 59 || cp == 44) {
                                if (i - paramStart == 6 && urlString.regionMatches(true, paramStart, "base64", 0, 6)) {
                                    base64 = true;
                                } else {
                                    contentTypeBuilder.append(';').append(urlString.substring(paramStart, i));
                                }
                                if (cp == 44) {
                                    boolean bl = text = contentTypeBuilder.lastIndexOf("text/", 5) != -1;
                                    if (text && charsetName != null) {
                                        contentTypeBuilder.insert(postCt, ";charset=" + charsetName);
                                    }
                                    contentType = contentTypeBuilder.toString();
                                    content = urlString.offsetByCodePoints(i, 1);
                                    break;
                                }
                                paramStart = urlString.offsetByCodePoints(i, 1);
                            } else {
                                if (cp != 61) {
                                    throw DataURLConnection.invalidChar(i);
                                }
                                paramEnd = i;
                                state = 4;
                            }
                        }
                    } else {
                        if (state != 4) {
                            throw new IllegalStateException();
                        }
                        if (!DataURLConnection.isCTToken(cp)) {
                            if (cp != 59 && cp != 44) {
                                throw DataURLConnection.invalidChar(i);
                            }
                            String value = urlString.substring(paramEnd + 1, i);
                            if (paramEnd - paramStart == 7 && urlString.regionMatches(true, paramStart, "charset", 0, 7)) {
                                try {
                                    charset = Charset.forName(value);
                                }
                                catch (UnsupportedCharsetException e) {
                                    throw e;
                                }
                                catch (Throwable t) {
                                    UnsupportedCharsetException uce = new UnsupportedCharsetException(value);
                                    uce.initCause(t);
                                    throw uce;
                                }
                                charsetName = value;
                            } else {
                                contentTypeBuilder.append(urlString.substring(paramStart, i));
                            }
                            if (cp == 44) {
                                boolean bl = text = contentTypeBuilder.lastIndexOf("text/", 5) != -1;
                                if (text && charsetName != null) {
                                    contentTypeBuilder.insert(postCt, ";charset=" + charsetName);
                                }
                                contentType = contentTypeBuilder.toString();
                                content = urlString.offsetByCodePoints(i, 1);
                                break;
                            }
                            state = 3;
                        }
                    }
                }
                i = urlString.offsetByCodePoints(i, 1);
            }
            if (content == -1) {
                throw new ProtocolException("Missing content");
            }
            if (base64) {
                bytes = Base64.getMimeDecoder().decode(urlString.substring(content).replaceAll("\\s+", ""));
                str = text ? new String(bytes, charset) : null;
            } else if (text) {
                str = URLDecoder.decode(urlString.substring(content), charset.name());
                bytes = str.getBytes(charset);
            } else {
                bytes = URLDecoder.decode(urlString.substring(content), StandardCharsets.ISO_8859_1.name()).getBytes(StandardCharsets.ISO_8859_1);
                str = null;
            }
            this.content = bytes;
            this.contentType = contentType;
            this.contentString = str;
        }

        private static ProtocolException invalidChar(int pos) {
            return new ProtocolException("Invalid character at position " + pos);
        }

        private static boolean isCTToken(int cp) {
            return 33 <= cp && cp <= 126 && cp != 40 && cp != 41 && cp != 60 && cp != 62 && cp != 64 && cp != 44 && cp != 59 && cp != 58 && cp != 92 && cp != 34 && cp != 47 && cp != 91 && cp != 93 && cp != 63 && cp != 61;
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        @Override
        public int getContentLength() {
            return this.content.length;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public Object getContent() {
            return this.contentString != null ? this.contentString : this.content.clone();
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.content);
        }
    }
}

