/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.logging.Logger;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class MessageLoggerTranslator
extends ClassModel {
    private static final String LOGGER_PARAMETER_NAME = "logger";
    private final Map<MessageMethod, String> translations;
    private final String locale;

    public MessageLoggerTranslator(Filer filer, MessageInterface messageInterface, String className, String superClassName, String locale, Map<MessageMethod, String> translations) {
        super(filer, messageInterface, className, superClassName);
        this.locale = locale;
        this.translations = translations != null ? translations : Collections.emptyMap();
    }

    @Override
    public JClassDef generateModel() throws IllegalStateException {
        JClassDef classDef = super.generateModel();
        JMethodDef constructor = classDef.constructor(32);
        constructor.param(2, Logger.class, LOGGER_PARAMETER_NAME);
        JBlock constructorBody = constructor.body();
        constructorBody.callSuper().arg((JExpr)JExprs.$v((String)LOGGER_PARAMETER_NAME));
        this.createLocaleGetter(this.locale, true);
        Set<Map.Entry<MessageMethod, String>> entries = this.translations.entrySet();
        LinkedHashSet<JMethodDef> methodNames = new LinkedHashSet<JMethodDef>();
        for (Map.Entry<MessageMethod, String> entry : entries) {
            JMethodDef method = this.addMessageMethod(entry.getKey(), entry.getValue());
            if (!methodNames.add(method)) continue;
            method.annotate(Override.class);
        }
        return classDef;
    }
}

