/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JIf;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.Fields;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Properties;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Suppressed;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.apt.ProcessingException;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;

abstract class ImplementationClassModel
extends ClassModel {
    private final AtomicBoolean messageFormatMethodGenerated = new AtomicBoolean(false);

    ImplementationClassModel(Filer filer, MessageInterface messageInterface) {
        super(filer, messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
    }

    /*
     * WARNING - void declaration
     */
    void createBundleMethod(JClassDef classDef, JCall localeGetter, MessageMethod messageMethod) {
        void var14_19;
        JCall formatterCall;
        this.addMessageMethod(messageMethod);
        JType returnType = JTypes.$t((String)messageMethod.returnType().name());
        this.sourceFile._import(returnType);
        JMethodDef method = classDef.method(34, returnType, messageMethod.name());
        method.annotate(Override.class);
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        MessageMethod.Message message = messageMethod.message();
        switch (message.format()) {
            case MESSAGE_FORMAT: {
                if (messageMethod.formatParameterCount() > 0) {
                    formatterCall = this.getFormatMethod(classDef, localeGetter);
                    formatterCall.arg((JExpr)JExprs.call((String)messageMethod.messageMethodName()));
                    break;
                }
                formatterCall = JExprs.call((String)messageMethod.messageMethodName());
                break;
            }
            case PRINTF: {
                JType formatter = JTypes.$t(String.class);
                formatterCall = formatter.call("format").arg((JExpr)localeGetter).arg((JExpr)JExprs.call((String)messageMethod.messageMethodName()));
                break;
            }
            default: {
                formatterCall = JExprs.call((String)messageMethod.messageMethodName());
            }
        }
        Set<Parameter> allParameters = messageMethod.parameters();
        LinkedHashMap<String, JParamDeclaration> fields = new LinkedHashMap<String, JParamDeclaration>();
        LinkedHashMap<String, JParamDeclaration> properties = new LinkedHashMap<String, JParamDeclaration>();
        ArrayList<String> parameterNames = new ArrayList<String>(allParameters.size());
        for (Parameter parameter : allParameters) {
            parameterNames.add(parameter.name());
        }
        ArrayList<Object> args = new ArrayList<Object>();
        for (Parameter parameter : allParameters) {
            JParamDeclaration var = this.addMethodParameter(method, parameter);
            String formatterClass = parameter.formatterClass();
            if (parameter.isFormatParameter()) {
                boolean added = false;
                if (parameter.isAnnotatedWith(Transform.class)) {
                    if (formatterCall == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    JAssignableExpr transformVar = this.createTransformVar(parameterNames, body, parameter, (JExpr)JExprs.$v((JParamDeclaration)var));
                    if (formatterClass == null) {
                        args.add(transformVar);
                    } else {
                        args.add(JTypes.$t((String)formatterClass)._new().arg((JExpr)transformVar));
                    }
                    added = true;
                }
                if (parameter.isAnnotatedWith(Pos.class)) {
                    if (formatterCall == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    Pos pos = parameter.getAnnotation(Pos.class);
                    int[] positions = pos.value();
                    Transform[] transform = pos.transform();
                    for (int i = 0; i < positions.length; ++i) {
                        int index = positions[i] - 1;
                        if (transform != null && transform.length > 0) {
                            JAssignableExpr tVar = this.createTransformVar(parameterNames, method.body(), parameter, transform[i], (JExpr)JExprs.$v((JParamDeclaration)var));
                            if (index < args.size()) {
                                args.add(index, tVar);
                                continue;
                            }
                            args.add(tVar);
                            continue;
                        }
                        if (index < args.size()) {
                            args.add(index, JExprs.$v((JParamDeclaration)var));
                            continue;
                        }
                        args.add(JExprs.$v((JParamDeclaration)var));
                    }
                    added = true;
                }
                if (!added) {
                    if (formatterCall == null) {
                        throw new ProcessingException(messageMethod, "No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    if (formatterClass == null) {
                        if (parameter.isArray() || parameter.isVarArgs()) {
                            JType arrays = JTypes.$t(Arrays.class);
                            this.sourceFile._import(arrays);
                            args.add(arrays.call("toString").arg((JExpr)JExprs.$v((JParamDeclaration)var)));
                        } else {
                            args.add(JExprs.$v((JParamDeclaration)var));
                        }
                    } else {
                        args.add(JTypes.$t((String)formatterClass)._new().arg((JExpr)JExprs.$v((JParamDeclaration)var)));
                    }
                }
            }
            if (parameter.isAnnotatedWith(Field.class)) {
                fields.put(parameter.targetName(), var);
            }
            if (!parameter.isAnnotatedWith(Property.class)) continue;
            properties.put(parameter.targetName(), var);
        }
        for (JExpr jExpr : args) {
            formatterCall.arg(jExpr);
        }
        if (messageMethod.returnType().isThrowable()) {
            JAssignableExpr jAssignableExpr = JExprs.$v((JVarDeclaration)this.createReturnType(messageMethod, body, formatterCall));
        } else {
            JCall jCall = formatterCall;
        }
        for (Map.Entry entry : fields.entrySet()) {
            body.assign(var14_19.field((String)entry.getKey()), (JExpr)JExprs.$v((JParamDeclaration)((JParamDeclaration)entry.getValue())));
        }
        for (Map.Entry entry : properties.entrySet()) {
            body.add((JExpr)var14_19.call((String)entry.getKey()).arg((JExpr)JExprs.$v((JParamDeclaration)((JParamDeclaration)entry.getValue()))));
        }
        body._return((JExpr)var14_19);
    }

    JAssignableExpr createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, JExpr var) {
        return this.createTransformVar(parameterNames, methodBody, param, param.getAnnotation(Transform.class), var);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JAssignableExpr createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, Transform transform, JExpr var) {
        JAssignableExpr result;
        List<Transform.TransformType> transformTypes = Arrays.asList(transform.value());
        if (transformTypes.contains(Transform.TransformType.GET_CLASS)) {
            if (transformTypes.size() == 1) {
                String paramName = this.getUniqueName(parameterNames, param, "Class");
                parameterNames.add(paramName);
                result = JExprs.$v((JVarDeclaration)methodBody.var(2, JTypes.$t(Class.class).typeArg(new JType[]{JType.WILDCARD}), paramName));
                JIf stmt = methodBody._if(var.eq(JExpr.NULL));
                stmt.block(JBlock.Braces.REQUIRED).assign(result, JExpr.NULL);
                stmt._else().assign(result, (JExpr)var.call("getClass"));
                return result;
            } else {
                String paramName = this.getUniqueName(parameterNames, param, "HashCode");
                parameterNames.add(paramName);
                result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
                JIf stmt = methodBody._if(var.eq(JExpr.NULL));
                stmt.assign(result, JExpr.ZERO);
                if (transformTypes.contains(Transform.TransformType.HASH_CODE)) {
                    stmt._else().assign(result, (JExpr)var.call("getClass").call("hashCode"));
                    return result;
                } else {
                    if (!transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE)) throw new IllegalStateException(String.format("Invalid transform type combination: %s", transformTypes));
                    stmt._else().assign(result, (JExpr)JTypes.$t(System.class).call("identityHashCode").arg((JExpr)var.call("getClass")));
                }
            }
            return result;
        } else if (transformTypes.contains(Transform.TransformType.HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            if (param.isArray() || param.isVarArgs()) {
                JType arrays = JTypes.$t(Arrays.class);
                this.sourceFile._import(arrays);
                stmt._else().assign(result, (JExpr)arrays.call("hashCode").arg(var));
                return result;
            } else {
                stmt._else().assign(result, (JExpr)var.call("hashCode"));
            }
            return result;
        } else if (transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            stmt._else().assign(result, (JExpr)JTypes.$t(System.class).call("identityHashCode").arg(var));
            return result;
        } else {
            if (!transformTypes.contains(Transform.TransformType.SIZE)) throw new IllegalStateException(String.format("Invalid transform type: %s", transformTypes));
            String paramName = this.getUniqueName(parameterNames, param, "Size");
            parameterNames.add(paramName);
            result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            if (param.isArray() || param.isVarArgs()) {
                stmt._else().assign(result, (JExpr)var.field("length"));
                return result;
            } else if (param.isSubtypeOf(Map.class) || param.isSubtypeOf(Collection.class)) {
                stmt._else().assign(result, (JExpr)var.call("size"));
                return result;
            } else {
                if (!param.isSubtypeOf(CharSequence.class)) throw new IllegalStateException(String.format("Invalid type for %s. Must be an array, %s, %s or %s.", Transform.TransformType.SIZE, Collection.class.getName(), Map.class.getName(), CharSequence.class.getName()));
                stmt._else().assign(result, (JExpr)var.call("length"));
            }
        }
        return result;
    }

    private String getUniqueName(List<String> parameterNames, Parameter parameter, String suffix) {
        String result;
        String string = result = suffix == null ? parameter.name() : parameter.name().concat(suffix);
        if (parameterNames.contains(result)) {
            return this.getUniqueName(parameterNames, new StringBuilder(result), 0);
        }
        return result;
    }

    private String getUniqueName(List<String> parameterNames, StringBuilder sb, int index) {
        String result = sb.append(index).toString();
        if (parameterNames.contains(result)) {
            return this.getUniqueName(parameterNames, sb, index + 1);
        }
        return result;
    }

    private JVarDeclaration createReturnType(MessageMethod messageMethod, JBlock body, JCall format) {
        boolean callInitCause = false;
        ThrowableType returnType = messageMethod.returnType().throwableReturnType();
        JType type = JTypes.$t((String)returnType.name());
        this.sourceFile._import(type);
        JCall result = type._new();
        JVarDeclaration resultField = body.var(2, type, "result", (JExpr)result);
        if (returnType.useConstructionParameters()) {
            for (Parameter param : returnType.constructionParameters()) {
                if (param.isMessageMethod()) {
                    result.arg((JExpr)format);
                    continue;
                }
                result.arg((JExpr)JExprs.$v((String)param.name()));
            }
            callInitCause = messageMethod.hasCause() && !returnType.causeSetInConstructor();
        } else if (returnType.hasStringAndThrowableConstructor() && messageMethod.hasCause()) {
            result.arg((JExpr)format).arg((JExpr)JExprs.$v((String)messageMethod.cause().name()));
        } else if (returnType.hasThrowableAndStringConstructor() && messageMethod.hasCause()) {
            result.arg((JExpr)JExprs.$v((String)messageMethod.cause().name())).arg((JExpr)format);
        } else if (returnType.hasStringConstructor()) {
            result.arg((JExpr)format);
            if (messageMethod.hasCause()) {
                callInitCause = true;
            }
        } else if (returnType.hasThrowableConstructor() && messageMethod.hasCause()) {
            result.arg((JExpr)JExprs.$v((String)messageMethod.cause().name()));
        } else if (returnType.hasStringAndThrowableConstructor() && !messageMethod.hasCause()) {
            result.arg((JExpr)format).arg(JExpr.NULL);
        } else if (returnType.hasThrowableAndStringConstructor() && !messageMethod.hasCause()) {
            result.arg(JExpr.NULL).arg((JExpr)format);
        } else if (messageMethod.hasCause()) {
            callInitCause = true;
        }
        if (callInitCause) {
            body.add((JExpr)JExprs.$v((JVarDeclaration)resultField).call("initCause").arg((JExpr)JExprs.$v((String)messageMethod.cause().name())));
        }
        this.addDefultProperties(messageMethod, ElementHelper.getAnnotations(messageMethod, Properties.class, Property.class), body, JExprs.$v((JVarDeclaration)resultField), false);
        this.addDefultProperties(messageMethod, ElementHelper.getAnnotations(messageMethod, Fields.class, Field.class), body, JExprs.$v((JVarDeclaration)resultField), true);
        JType arrays = JTypes.$t(Arrays.class);
        this.sourceFile._import(arrays);
        JVarDeclaration st = body.var(2, JTypes.$t(StackTraceElement.class).array(), "st", (JExpr)JExprs.$v((JVarDeclaration)resultField).call("getStackTrace"));
        body.add((JExpr)JExprs.$v((JVarDeclaration)resultField).call("setStackTrace").arg((JExpr)arrays.call("copyOfRange").arg((JExpr)JExprs.$v((JVarDeclaration)st)).arg(JExpr.ONE).arg((JExpr)JExprs.$v((JVarDeclaration)st).field("length"))));
        Set<Parameter> suppressed = messageMethod.parametersAnnotatedWith(Suppressed.class);
        for (Parameter p : suppressed) {
            String name;
            if (p.isArray() || p.isVarArgs()) {
                name = String.format("$%sVar", p.name());
                body.forEach(0, JTypes.typeOf((TypeMirror)((ArrayType)p.asType()).getComponentType()), " " + name, (JExpr)JExprs.$v((String)p.name())).block(JBlock.Braces.REQUIRED).add((JExpr)JExprs.$v((JVarDeclaration)resultField).call("addSuppressed").arg((JExpr)JExprs.$v((String)name)));
                continue;
            }
            if (p.isAssignableFrom(Collection.class)) {
                name = String.format("$%sVar", p.name());
                body.add((JExpr)JExprs.$v((String)p.name()).call("forEach").arg((JExpr)JExprs.lambda().param(name).body((JExpr)JExprs.$v((JVarDeclaration)resultField).call("addSuppressed").arg((JExpr)JExprs.$v((String)name)))));
                continue;
            }
            body.add((JExpr)JExprs.$v((JVarDeclaration)resultField).call("addSuppressed").arg((JExpr)JExprs.$v((String)p.name())));
        }
        return resultField;
    }

    protected final void addThrownTypes(MessageMethod messageMethod, JMethodDef jMethod) {
        for (ThrowableType thrownType : messageMethod.thrownTypes()) {
            jMethod._throws(thrownType.name());
        }
    }

    protected JParamDeclaration addMethodParameter(JMethodDef method, Parameter param) {
        JType paramType = JTypes.typeOf((TypeMirror)param.asType());
        if (!param.isPrimitive()) {
            this.sourceFile._import(paramType);
        }
        return method.param(2, paramType, param.name());
    }

    private void addDefultProperties(MessageMethod messageMethod, Collection<AnnotationMirror> annotations, JBlock body, JAssignableExpr resultField, boolean field) {
        for (AnnotationMirror propertyAnnotation : annotations) {
            String name = null;
            AnnotationValue annotationValue = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : propertyAnnotation.getElementValues().entrySet()) {
                ExecutableElement attribute = entry.getKey();
                AnnotationValue attributeValue = entry.getValue();
                if ("name".contentEquals(attribute.getSimpleName())) {
                    name = String.valueOf(attributeValue.getValue());
                    continue;
                }
                annotationValue = attributeValue;
            }
            if (name == null) {
                throw new ProcessingException((Element)messageMethod, propertyAnnotation, "The name attribute is required for the annotation.");
            }
            if (annotationValue == null || annotationValue.getValue() == null) {
                throw new ProcessingException((Element)messageMethod, propertyAnnotation, "A value for one of the default attributes is required.");
            }
            JExpr resultValue = annotationValue.accept(JExprAnnotationValueVisitor.INSTANCE, null);
            if (resultValue == null) {
                Object value = annotationValue.getValue();
                throw new ProcessingException((Element)messageMethod, propertyAnnotation, annotationValue, "Could not resolve value type for %s (%s)", value, value.getClass());
            }
            if (field) {
                body.add(resultField.field(name).assign(resultValue));
                continue;
            }
            body.add((JExpr)resultField.call("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1)).arg(resultValue));
        }
    }

    private JCall getFormatMethod(JClassDef classDef, JCall localeGetter) {
        String methodName = "_formatMessage";
        if (this.messageFormatMethodGenerated.compareAndSet(false, true)) {
            JMethodDef method = classDef.method(8, String.class, "_formatMessage");
            JParamDeclaration format = method.param(2, String.class, "format");
            JParamDeclaration args = method.varargParam(2, Object.class, "args");
            JBlock body = method.body();
            JType formatterType = JTypes.$t(MessageFormat.class);
            JCall initializer = formatterType._new().arg((JExpr)JExprs.$v((JParamDeclaration)format)).arg((JExpr)localeGetter);
            JVarDeclaration formatter = body.var(2, formatterType, "formatter", (JExpr)initializer);
            body._return((JExpr)JExprs.$v((JVarDeclaration)formatter).call("format").arg((JExpr)JExprs.$v((JParamDeclaration)args)).arg((JExpr)JTypes.$t(StringBuffer.class)._new()).arg((JExpr)JTypes.$t(FieldPosition.class)._new().arg(JExpr.ZERO)).call("toString"));
        }
        return JExprs.call((String)"_formatMessage");
    }

    private static class JExprAnnotationValueVisitor
    extends SimpleAnnotationValueVisitor8<JExpr, Void> {
        private static final JExprAnnotationValueVisitor INSTANCE = new JExprAnnotationValueVisitor();

        private JExprAnnotationValueVisitor() {
        }

        @Override
        public JExpr visitBoolean(boolean b, Void v) {
            return b ? JExpr.TRUE : JExpr.FALSE;
        }

        @Override
        public JExpr visitByte(byte b, Void v) {
            return JExprs.decimal((int)b).cast(JType.BYTE);
        }

        @Override
        public JExpr visitChar(char c, Void v) {
            return JExprs.ch((int)c);
        }

        @Override
        public JExpr visitDouble(double d, Void v) {
            return JExprs.$v((String)String.format("%ad", d));
        }

        @Override
        public JExpr visitFloat(float f, Void v) {
            return JExprs.hex((float)f);
        }

        @Override
        public JExpr visitInt(int i, Void v) {
            return JExprs.decimal((int)i);
        }

        @Override
        public JExpr visitLong(long i, Void v) {
            return JExprs.decimal((long)i);
        }

        @Override
        public JExpr visitShort(short s, Void v) {
            return JExprs.decimal((int)s).cast(JType.SHORT);
        }

        @Override
        public JExpr visitString(String s, Void v) {
            return JExprs.str((String)s);
        }

        @Override
        public JExpr visitType(TypeMirror t, Void v) {
            return JExprs.$v((String)(t.toString() + ".class"));
        }
    }
}

