/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt.report;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Optional;
import org.jboss.logging.processor.apt.report.ReportWriter;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class AsciidocReportWriter
extends ReportWriter {
    protected AsciidocReportWriter(BufferedWriter writer) {
        super(writer);
    }

    @Override
    public void write(MessageInterface messageInterface) throws IOException {
        this.writeTableHeader(messageInterface);
        String idFormat = AsciidocReportWriter.createMessageIdFormat(messageInterface);
        for (MessageMethod messageMethod : this.getSortedMessageMethods(messageInterface)) {
            this.writeTableRow(idFormat, messageMethod);
        }
        this.writeTableEnd();
    }

    @Override
    public void writeStart(Optional<String> title) throws IOException {
        this.writer.write("= ");
        this.writer.write(this.escape(title.orElse("Messages")).toString());
        this.writer.newLine();
        this.writer.newLine();
    }

    private void writeTableHeader(MessageInterface messageInterface) throws IOException {
        this.writer.append('.').append(messageInterface.name());
        this.writer.newLine();
        this.writer.write("|===");
        this.writer.newLine();
        this.writer.write("|Message Id |Message |Log Level |Return Type");
        this.writer.newLine();
        this.writer.newLine();
    }

    private void writeTableRow(String idFormat, MessageMethod method) throws IOException {
        MessageMethod.Message msg = method.message();
        String id = msg.hasId() ? String.format(idFormat, msg.id()) : "none";
        this.writer.append('|').append(this.escape(id));
        this.writer.newLine();
        this.writer.append('|').append(this.escape(msg.value()));
        this.writer.newLine();
        if (method.isLoggerMethod()) {
            this.writer.append('|').append(this.getLogLevel(method));
            this.writer.newLine();
            this.writer.append("|void");
        } else {
            this.writer.append("|--");
            this.writer.newLine();
            this.writer.append('|').append(method.returnType().name());
        }
        this.writer.newLine();
        this.writer.newLine();
    }

    private void writeTableEnd() throws IOException {
        this.writer.write("|===");
        this.writer.newLine();
    }

    private CharSequence escape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int sqPos = -1;
        int aPos = -1;
        int offset = 0;
        char previous = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    if (sqPos >= 0) {
                        sb.insert(sqPos + offset++, '\\');
                        sqPos = -1;
                        break;
                    }
                    sqPos = i;
                    break;
                }
                case '*': {
                    char next;
                    if (aPos >= 0) {
                        if (previous != ' ') {
                            sb.insert(aPos + offset++, '\\');
                        }
                        aPos = -1;
                        break;
                    }
                    if (i + 1 >= len || (next = s.charAt(i + 1)) == ' ') break;
                    aPos = i;
                }
            }
            previous = c;
            sb.append(c);
        }
        return sb;
    }
}

