/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.ConstructType;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.LoggingClass;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Signature;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.apt.ImplementationClassGenerator;
import org.jboss.logging.processor.apt.MessageInterfaceFactory;
import org.jboss.logging.processor.apt.ProcessingException;
import org.jboss.logging.processor.apt.ReportFileGenerator;
import org.jboss.logging.processor.apt.ToolLogger;
import org.jboss.logging.processor.apt.TranslationClassGenerator;
import org.jboss.logging.processor.apt.TranslationFileGenerator;
import org.jboss.logging.processor.model.DelegatingElement;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.Validator;

@SupportedOptions(value={"debug", "expressionProperties"})
public class LoggingToolsProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    static final String EXPRESSION_PROPERTIES = "expressionProperties";
    private final List<String> interfaceAnnotations = Arrays.asList(MessageBundle.class.getName(), MessageLogger.class.getName());
    private final List<AbstractGenerator> generators = new ArrayList<AbstractGenerator>();
    private final Set<String> supportedAnnotations = LoggingToolsProcessor.createSupportedAnnotations(Cause.class, ConstructType.class, Field.class, FormatWith.class, LoggingClass.class, LogMessage.class, Message.class, MessageBundle.class, MessageLogger.class, Once.class, Param.class, Pos.class, Property.class, Signature.class, Transform.class, ValidIdRange.class, ValidIdRanges.class);
    private ToolLogger logger;

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>();
        SupportedOptions globalOptions = this.getClass().getAnnotation(SupportedOptions.class);
        if (globalOptions != null) {
            supportedOptions.addAll(Arrays.asList(globalOptions.value()));
        }
        for (AbstractGenerator generator : this.generators) {
            supportedOptions.addAll(generator.getSupportedOptions());
        }
        return supportedOptions;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger = ToolLogger.getLogger(processingEnv);
        this.generators.add(new ImplementationClassGenerator(processingEnv));
        this.generators.add(new TranslationClassGenerator(processingEnv));
        this.generators.add(new TranslationFileGenerator(processingEnv));
        this.generators.add(new ReportFileGenerator(processingEnv));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.doProcess(annotations, roundEnv);
        }
        return true;
    }

    private void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String propertiesPath = this.processingEnv.getOptions().getOrDefault(EXPRESSION_PROPERTIES, "");
        Properties expressionProperties = new Properties();
        if (!propertiesPath.isEmpty()) {
            Path path = Paths.get(propertiesPath, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                this.logger.error("Expression properties file %s does not exist.", propertiesPath);
                return;
            }
            try {
                BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                Object object = null;
                try {
                    expressionProperties.load(reader);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "Error reading expression properties file %s", propertiesPath);
                return;
            }
        }
        boolean generate = true;
        Validator validator = new Validator(this.processingEnv);
        for (TypeElement typeElement : annotations) {
            if (!this.interfaceAnnotations.contains(typeElement.getQualifiedName().toString())) continue;
            try {
                Set<TypeElement> interfaces = ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement));
                for (TypeElement interfaceElement : interfaces) {
                    try {
                        MessageInterface messageInterface = MessageInterfaceFactory.of(this.processingEnv, interfaceElement, expressionProperties);
                        Collection<ValidationMessage> validationMessages = validator.validate(messageInterface);
                        for (ValidationMessage message : validationMessages) {
                            if (!message.printMessage(this.processingEnv.getMessager())) continue;
                            generate = false;
                        }
                        if (!generate || !interfaceElement.getKind().isInterface() || interfaceElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                        for (AbstractGenerator processor : this.generators) {
                            this.logger.debug("Executing processor %s", processor.getName());
                            processor.processTypeElement(typeElement, interfaceElement, messageInterface);
                        }
                    }
                    catch (ProcessingException e) {
                        AnnotationMirror a = e.getAnnotation();
                        AnnotationValue value = e.getAnnotationValue();
                        Element element = LoggingToolsProcessor.resolveElement(e.getElement());
                        if (a == null) {
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element);
                            continue;
                        }
                        if (value == null) {
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element, a);
                            continue;
                        }
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), element, a, value);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error((Element)typeElement, t);
            }
        }
    }

    @SafeVarargs
    private static Set<String> createSupportedAnnotations(Class<? extends Annotation> ... annotations) {
        HashSet<String> supportedAnnotations = new HashSet<String>(annotations.length);
        for (Class<? extends Annotation> c : annotations) {
            supportedAnnotations.add(c.getName());
        }
        return Collections.unmodifiableSet(supportedAnnotations);
    }

    private static Element resolveElement(Element element) {
        if (element instanceof DelegatingElement) {
            return ((DelegatingElement)element).getDelegate();
        }
        return element;
    }
}

