/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.processor.model.MessageObject;

public final class ElementHelper {
    private ElementHelper() {
    }

    public static boolean isAnnotatedWith(Element element, Class<? extends Annotation> clazz) {
        if (element == null) {
            throw new IllegalArgumentException("The element parameter is null");
        }
        Annotation annotation = element.getAnnotation(clazz);
        return annotation != null;
    }

    public static String getPrimaryClassNamePrefix(TypeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String translationFileName = element.getSimpleName().toString();
        for (Element enclosingElt = element.getEnclosingElement(); enclosingElt != null && enclosingElt instanceof TypeElement; enclosingElt = enclosingElt.getEnclosingElement()) {
            translationFileName = String.format("%s$%s", enclosingElt.getSimpleName().toString(), translationFileName);
        }
        return translationFileName;
    }

    public static Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!methodName.equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }

    public static Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName, int paramCount) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!methodName.equals(method.getSimpleName()) || ElementHelper.parameterCount(method.getParameters()) != paramCount) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean hasCause(Collection<? extends VariableElement> params) {
        for (VariableElement variableElement : params) {
            if (!ElementHelper.isAnnotatedWith(variableElement, Cause.class)) continue;
            return true;
        }
        return false;
    }

    public static int parameterCount(Collection<? extends VariableElement> params) {
        int result = params.size();
        for (VariableElement variableElement : params) {
            if (!ElementHelper.isAnnotatedWith(variableElement, Param.class) && !ElementHelper.isAnnotatedWith(variableElement, Field.class) && !ElementHelper.isAnnotatedWith(variableElement, Property.class)) continue;
            --result;
        }
        return result - (ElementHelper.hasCause(params) ? 1 : 0);
    }

    public static boolean inheritsMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        if (ElementHelper.isAnnotatedWith(method, Message.class)) {
            return false;
        }
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!ElementHelper.isAnnotatedWith(m, Message.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverloaded(Collection<ExecutableElement> methods, ExecutableElement method) {
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!method.getSimpleName().equals(m.getSimpleName()) || ElementHelper.parameterCount(method.getParameters()) == ElementHelper.parameterCount(m.getParameters())) continue;
            return true;
        }
        return false;
    }

    public static String typeToString(Class<?> type) {
        return ElementHelper.typeToString(type.getName());
    }

    public static String typeToString(String qualifiedType) {
        return qualifiedType.replace("$", ".");
    }

    public static Element fromMessageObject(MessageObject object) {
        if (object.reference() instanceof Element) {
            return (Element)object.reference();
        }
        return null;
    }

    public static TypeElement getClassAnnotationValue(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            AnnotationValue value = annotationMirror.getElementValues().values().iterator().next();
            return (TypeElement)((DeclaredType)value.getValue()).asElement();
        }
        return null;
    }

    public static TypeElement getClassAnnotationValue(Element element, Class<? extends Annotation> annotation, String attributeName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (!executableElement.getSimpleName().contentEquals(attributeName)) continue;
                return (TypeElement)((DeclaredType)map.get(executableElement).getValue()).asElement();
            }
        }
        return null;
    }

    public static List<TypeElement> getClassArrayAnnotationValue(Element element, Class<? extends Annotation> annotation, String attributeName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (!executableElement.getSimpleName().contentEquals(attributeName)) continue;
                List annotationValues = (List)map.get(executableElement).getValue();
                ArrayList<TypeElement> result = new ArrayList<TypeElement>(annotationValues.size());
                for (AnnotationValue value : annotationValues) {
                    result.add((TypeElement)((DeclaredType)value.getValue()).asElement());
                }
                return result;
            }
        }
        return Collections.emptyList();
    }
}

