/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jdeparser.JDefinedClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JMethod;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class MessageBundleTranslator
extends ClassModel {
    private final Map<MessageMethod, String> translations;

    public MessageBundleTranslator(MessageInterface messageInterface, String className, String superClassName, Map<MessageMethod, String> translations) {
        super(messageInterface, className, superClassName);
        this.translations = translations != null ? translations : Collections.emptyMap();
    }

    @Override
    public JDeparser generateModel() throws IllegalStateException {
        JDeparser model = super.generateModel();
        JDefinedClass definedClass = this.getDefinedClass();
        JMethod constructor = definedClass.constructor(2);
        constructor.body().invoke("super");
        JMethod readResolve = this.createReadResolveMethod();
        readResolve.annotate(Override.class);
        Set<Map.Entry<MessageMethod, String>> entries = this.translations.entrySet();
        LinkedHashSet<String> methodNames = new LinkedHashSet<String>();
        for (Map.Entry<MessageMethod, String> entry : entries) {
            JMethod method = this.addMessageMethod(entry.getKey(), entry.getValue());
            if (!methodNames.add(method.name())) continue;
            method.annotate(Override.class);
        }
        return model;
    }
}

