/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.sort;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.jboss.deployers.plugins.sort.DeployerSorter;
import org.jboss.deployers.spi.Ordered;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.util.graph.Edge;
import org.jboss.util.graph.Graph;
import org.jboss.util.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InOutTopologicalDeployerSorter
implements DeployerSorter {
    @Override
    public List<Deployer> sortDeployers(List<Deployer> original, Deployer newDeployer) {
        Graph graph = new Graph();
        HashMap<String, TreeSet<Deployer>> output2deployer = new HashMap<String, TreeSet<Deployer>>();
        SplitList splitList = new SplitList(original, newDeployer);
        TreeSet<Deployer> notUsed = new TreeSet<Deployer>(Ordered.COMPARATOR);
        for (Deployer deployer : splitList) {
            boolean used = false;
            Set inputs = deployer.getInputs();
            Set<Vertex<Integer>> ivd = InOutTopologicalDeployerSorter.fillVertices(inputs, (Graph<Integer>)graph);
            Set outputs = deployer.getOutputs();
            Set<Vertex<Integer>> ovd = InOutTopologicalDeployerSorter.fillVertices(outputs, (Graph<Integer>)graph);
            ivd.retainAll(ovd);
            for (String output : outputs) {
                TreeSet<Deployer> deployers = (TreeSet<Deployer>)output2deployer.get(output);
                if (deployers == null) {
                    deployers = new TreeSet<Deployer>(Ordered.COMPARATOR);
                    output2deployer.put(output, deployers);
                }
                deployers.add(deployer);
                used = true;
                for (String input : inputs) {
                    Vertex to;
                    Vertex from = graph.findVertexByName(input);
                    if (from == (to = graph.findVertexByName(output)) || ivd.contains(from)) continue;
                    graph.addEdge(from, to, 0);
                }
            }
            if (used) continue;
            notUsed.add(deployer);
        }
        Stack<Vertex> noIncoming = new Stack<Vertex>();
        for (Vertex vertex : graph.getVerticies()) {
            if (vertex.getIncomingEdgeCount() != 0) continue;
            noIncoming.push(vertex);
        }
        ArrayList<Vertex> sorted = new ArrayList<Vertex>();
        while (!noIncoming.isEmpty()) {
            Vertex n = (Vertex)noIncoming.pop();
            sorted.add(n);
            n.setData((Object)sorted.size());
            ArrayList edges = new ArrayList(n.getOutgoingEdges());
            for (Edge edge : edges) {
                Vertex m = edge.getTo();
                graph.removeEdge(n, m);
                if (m.getIncomingEdgeCount() != 0) continue;
                noIncoming.push(m);
            }
        }
        if (!graph.getEdges().isEmpty()) {
            throw new IllegalStateException("We have a cycle: " + newDeployer + ", previous: " + original);
        }
        LinkedHashSet<Deployer> sortedDeployers = new LinkedHashSet<Deployer>();
        for (Vertex v : sorted) {
            Set deployers = (Set)output2deployer.get(v.getName());
            if (deployers == null) continue;
            Deployer first = (Deployer)deployers.iterator().next();
            Iterator notUsedIter = notUsed.iterator();
            while (notUsedIter.hasNext()) {
                Deployer next = (Deployer)notUsedIter.next();
                if (!next.getInputs().isEmpty() || Ordered.COMPARATOR.compare(next, first) >= 0) continue;
                sortedDeployers.add(next);
                notUsedIter.remove();
            }
            for (Deployer deployer : deployers) {
                if (sortedDeployers.contains(deployer)) continue;
                sortedDeployers.add(deployer);
            }
        }
        sortedDeployers.addAll(notUsed);
        return new ArrayList<Deployer>(sortedDeployers);
    }

    private static Set<Vertex<Integer>> fillVertices(Set<String> keys, Graph<Integer> graph) {
        IdentityHashMap<Vertex<Integer>, Integer> dv = new IdentityHashMap<Vertex<Integer>, Integer>();
        for (String key : keys) {
            dv.put(InOutTopologicalDeployerSorter.getVertex(key, graph), 0);
        }
        return dv.keySet();
    }

    private static Vertex<Integer> getVertex(String key, Graph<Integer> graph) {
        Vertex vertex = graph.findVertexByName(key);
        if (vertex == null) {
            vertex = new Vertex(key);
            graph.addVertex(vertex);
        }
        return vertex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SplitList<T>
    extends AbstractList<T> {
        private List<T> head;
        private List<T> tail;

        private SplitList(List<T> head, T tail) {
            this.head = head;
            this.tail = Collections.singletonList(tail);
        }

        @Override
        public T get(int index) {
            int headSize = this.head.size();
            if (index < headSize) {
                return this.head.get(index);
            }
            return this.tail.get(index - headSize);
        }

        @Override
        public int size() {
            return this.head.size() + this.tail.size();
        }
    }
}

