/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.classloading.spi.dependency.LifeCycle;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.client.spi.DeployerClientChangeExt;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.plugins.classloading.AbstractDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.spi.deployer.DeploymentStages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentLifeCycle
extends LifeCycle {
    protected static Set<DeploymentLifeCycle> getDeploymentLifeCycles(LifeCycle[] lifecycles) {
        if (lifecycles == null || lifecycles.length == 0) {
            return null;
        }
        LinkedHashSet<DeploymentLifeCycle> result = new LinkedHashSet<DeploymentLifeCycle>(lifecycles.length);
        for (LifeCycle lifecycle : lifecycles) {
            if (lifecycle == null) {
                throw new IllegalArgumentException("Null lifecycle");
            }
            if (lifecycle instanceof DeploymentLifeCycle) {
                return null;
            }
            result.add((DeploymentLifeCycle)lifecycle);
        }
        return result;
    }

    public DeploymentLifeCycle(AbstractDeploymentClassLoaderPolicyModule module) {
        super((Module)module);
    }

    public AbstractDeploymentClassLoaderPolicyModule getModule() {
        return (AbstractDeploymentClassLoaderPolicyModule)super.getModule();
    }

    public boolean resolve() throws Exception {
        if (!this.isResolved()) {
            this.getMainDeployer().change(this.getModule().getDeploymentUnit().getName(), DeploymentStages.CLASSLOADER);
            return this.isResolved();
        }
        return true;
    }

    public boolean resolve(LifeCycle ... lifecycles) throws Exception {
        DeployerClientChangeExt changer = this.getChanger();
        Set<DeploymentLifeCycle> deploymentLifeCycles = null;
        if (changer != null) {
            deploymentLifeCycles = DeploymentLifeCycle.getDeploymentLifeCycles(lifecycles);
        }
        if (deploymentLifeCycles == null) {
            return super.resolve(lifecycles);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(lifecycles.length);
        for (DeploymentLifeCycle lifeCycle : deploymentLifeCycles) {
            if (lifeCycle.isResolved()) continue;
            names.add(lifeCycle.getModule().getDeploymentUnit().getName());
        }
        if (!names.isEmpty()) {
            try {
                changer.change(DeploymentStages.CLASSLOADER, true, names.toArray(new String[names.size()]));
            }
            catch (IncompleteDeploymentException e) {
                return false;
            }
        }
        return true;
    }

    public void unresolve() throws Exception {
        if (this.isResolved()) {
            this.getMainDeployer().change(this.getModule().getDeploymentUnit().getName(), DeploymentStages.DESCRIBE);
        }
    }

    public void unresolve(LifeCycle ... lifecycles) throws Exception {
        DeployerClientChangeExt changer = this.getChanger();
        Set<DeploymentLifeCycle> deploymentLifeCycles = null;
        if (changer != null) {
            deploymentLifeCycles = DeploymentLifeCycle.getDeploymentLifeCycles(lifecycles);
        }
        if (deploymentLifeCycles == null) {
            super.unresolve(lifecycles);
            return;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(lifecycles.length);
        for (DeploymentLifeCycle lifeCycle : deploymentLifeCycles) {
            if (!lifeCycle.isResolved()) continue;
            names.add(lifeCycle.getModule().getDeploymentUnit().getName());
        }
        if (!names.isEmpty()) {
            changer.change(DeploymentStages.DESCRIBE, false, names.toArray(new String[names.size()]));
        }
    }

    public void bounce() throws Exception {
        DeployerClientChangeExt changer = this.getChanger();
        if (changer == null) {
            throw new IllegalStateException("Don't know how to bounce " + this.getModule().getDeploymentUnit().getName());
        }
        changer.bounce(DeploymentStages.DESCRIBE, false, new String[]{this.getModule().getDeploymentUnit().getName()});
    }

    public void bounce(LifeCycle ... lifecycles) throws Exception {
        DeployerClientChangeExt changer = this.getChanger();
        Set<DeploymentLifeCycle> deploymentLifeCycles = null;
        if (changer != null) {
            deploymentLifeCycles = DeploymentLifeCycle.getDeploymentLifeCycles(lifecycles);
        }
        if (deploymentLifeCycles == null) {
            super.bounce(lifecycles);
            return;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(lifecycles.length);
        for (DeploymentLifeCycle lifeCycle : deploymentLifeCycles) {
            names.add(lifeCycle.getModule().getDeploymentUnit().getName());
        }
        changer.change(DeploymentStages.DESCRIBE, false, names.toArray(new String[names.size()]));
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            this.getMainDeployer().change(this.getModule().getDeploymentUnit().getName(), DeploymentStages.INSTALLED);
        }
    }

    public void start(LifeCycle ... lifecycles) throws Exception {
        DeployerClientChangeExt changer = this.getChanger();
        Set<DeploymentLifeCycle> deploymentLifeCycles = null;
        if (changer != null) {
            deploymentLifeCycles = DeploymentLifeCycle.getDeploymentLifeCycles(lifecycles);
        }
        if (deploymentLifeCycles == null) {
            super.start(lifecycles);
            return;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(lifecycles.length);
        for (DeploymentLifeCycle lifeCycle : deploymentLifeCycles) {
            if (lifeCycle.isStarted()) continue;
            names.add(lifeCycle.getModule().getDeploymentUnit().getName());
        }
        if (!names.isEmpty()) {
            changer.change(DeploymentStages.INSTALLED, false, names.toArray(new String[names.size()]));
        }
    }

    public void stop() throws Exception {
        if (this.isResolved()) {
            this.getMainDeployer().change(this.getModule().getDeploymentUnit().getName(), DeploymentStages.CLASSLOADER);
        }
    }

    public void stop(LifeCycle ... lifecycles) throws Exception {
        DeployerClientChangeExt changer = this.getChanger();
        Set<DeploymentLifeCycle> deploymentLifeCycles = null;
        if (changer != null) {
            deploymentLifeCycles = DeploymentLifeCycle.getDeploymentLifeCycles(lifecycles);
        }
        if (deploymentLifeCycles == null) {
            super.stop(lifecycles);
            return;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(lifecycles.length);
        for (DeploymentLifeCycle lifeCycle : deploymentLifeCycles) {
            if (!lifeCycle.isResolved()) continue;
            names.add(lifeCycle.getModule().getDeploymentUnit().getName());
        }
        if (!names.isEmpty()) {
            changer.change(DeploymentStages.CLASSLOADER, false, names.toArray(new String[names.size()]));
        }
    }

    protected MainDeployer getMainDeployer() {
        MainDeployer result = this.getModule().getDeploymentUnit().getMainDeployer();
        if (result == null) {
            throw new IllegalStateException("Unable to access main deployer");
        }
        return result;
    }

    protected DeployerClientChangeExt getChanger() {
        MainDeployer main = this.getMainDeployer();
        if (main instanceof DeployerClientChangeExt) {
            return (DeployerClientChangeExt)main;
        }
        return null;
    }
}

