/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.jpa;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.transaction.Transactional;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.IdBuilder;
import org.javers.core.Javers;
import org.javers.core.changelog.ChangeProcessor;
import org.javers.core.commit.Commit;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.sql.JaversSqlRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class JaversTransactionalDecorator
implements Javers {
    private final Javers delegate;
    private final JaversSqlRepository javersSqlRepository;
    @Autowired
    protected PlatformTransactionManager txManager;

    JaversTransactionalDecorator(Javers delegate, JaversSqlRepository javersSqlRepository) {
        this.delegate = delegate;
        this.javersSqlRepository = javersSqlRepository;
    }

    @Transactional
    public Commit commit(String author, Object currentVersion) {
        return this.delegate.commit(author, currentVersion);
    }

    @Transactional
    public Commit commitShallowDelete(String author, Object deleted) {
        return this.delegate.commitShallowDelete(author, deleted);
    }

    @Transactional
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId) {
        return this.delegate.commitShallowDeleteById(author, globalId);
    }

    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.delegate.compare(oldVersion, currentVersion);
    }

    public <T> Diff compareCollections(Collection<T> oldVersion, Collection<T> currentVersion, Class<T> itemClass) {
        return this.delegate.compareCollections(oldVersion, currentVersion, itemClass);
    }

    public Diff initial(Object newDomainObject) {
        return this.delegate.initial(newDomainObject);
    }

    @Transactional
    public Optional<CdoSnapshot> getLatestSnapshot(Object localId, Class entityClass) {
        return this.delegate.getLatestSnapshot(localId, entityClass);
    }

    @Transactional
    public List<CdoSnapshot> findSnapshots(JqlQuery query) {
        return this.delegate.findSnapshots(query);
    }

    @Transactional
    public List<Change> findChanges(JqlQuery query) {
        return this.delegate.findChanges(query);
    }

    public JsonConverter getJsonConverter() {
        return this.delegate.getJsonConverter();
    }

    public <T> T processChangeList(List<Change> changes, ChangeProcessor<T> changeProcessor) {
        return (T)this.delegate.processChangeList(changes, changeProcessor);
    }

    public <T extends JaversType> T getTypeMapping(Type clientsType) {
        return (T)this.delegate.getTypeMapping(clientsType);
    }

    public IdBuilder idBuilder() {
        return this.delegate.idBuilder();
    }

    @PostConstruct
    public void ensureSchema() {
        Validate.argumentIsNotNull((Object)this.txManager, (String)"TransactionManager is null");
        TransactionTemplate tmpl = new TransactionTemplate(this.txManager);
        tmpl.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JaversTransactionalDecorator.this.javersSqlRepository.ensureSchema();
            }
        });
    }

    public Property getProperty(PropertyChange propertyChange) {
        return this.delegate.getProperty(propertyChange);
    }
}

