/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.sql;

import java.util.HashMap;
import java.util.Map;
import org.javers.common.collections.Function;
import org.javers.repository.sql.DialectName;
import org.springframework.orm.jpa.vendor.Database;

public class DialectMapper
implements Function<Database, DialectName> {
    private static final Map<Database, DialectName> mapping = new HashMap(){
        {
            this.put(Database.DEFAULT, DialectName.H2);
            this.put(Database.H2, DialectName.H2);
            this.put(Database.SQL_SERVER, DialectName.MSSQL);
            this.put(Database.ORACLE, DialectName.ORACLE);
            this.put(Database.MYSQL, DialectName.MYSQL);
            this.put(Database.POSTGRESQL, DialectName.POSTGRES);
        }
    };

    public DialectName apply(Database hibernateDialectName) {
        return mapping.get(hibernateDialectName);
    }
}

