/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import org.javers.common.string.Strings;
import org.javers.core.AbstractContainerBuilder;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.repository.sql.SqlRepositoryConfiguration;
import org.javers.repository.sql.pico.JaversSqlModule;
import org.javers.repository.sql.session.SessionFactory;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.PolyJDBCBuilder;
import org.polyjdbc.core.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRepositoryBuilder
extends AbstractContainerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlRepositoryBuilder.class);
    private DialectName dialectName;
    private ConnectionProvider connectionProvider;
    private String schemaName;
    private boolean globalIdCacheDisabled;
    private boolean schemaManagementEnabled = true;
    private String globalIdTableName;
    private String commitTableName;
    private String snapshotTableName;
    private String commitPropertyTableName;

    public static SqlRepositoryBuilder sqlRepository() {
        return new SqlRepositoryBuilder();
    }

    public SqlRepositoryBuilder withDialect(DialectName dialect) {
        this.dialectName = dialect;
        return this;
    }

    public SqlRepositoryBuilder withConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public SqlRepositoryBuilder withSchema(String schemaName) {
        if (Strings.isNonEmpty((String)schemaName)) {
            this.schemaName = schemaName;
        }
        return this;
    }

    public SqlRepositoryBuilder withGlobalIdCacheDisabled(boolean globalIdCacheDisabled) {
        this.globalIdCacheDisabled = globalIdCacheDisabled;
        return this;
    }

    public SqlRepositoryBuilder withSchemaManagementEnabled(boolean schemaManagementEnabled) {
        this.schemaManagementEnabled = schemaManagementEnabled;
        return this;
    }

    public SqlRepositoryBuilder withGlobalIdTableName(String globalIdTableName) {
        if (Strings.isNonEmpty((String)globalIdTableName)) {
            this.globalIdTableName = globalIdTableName;
        }
        return this;
    }

    public SqlRepositoryBuilder withCommitTableName(String commitTableName) {
        if (Strings.isNonEmpty((String)commitTableName)) {
            this.commitTableName = commitTableName;
        }
        return this;
    }

    public SqlRepositoryBuilder withSnapshotTableName(String snapshotTableName) {
        if (Strings.isNonEmpty((String)snapshotTableName)) {
            this.snapshotTableName = snapshotTableName;
        }
        return this;
    }

    public SqlRepositoryBuilder withCommitPropertyTableName(String commitPropertyTableName) {
        if (Strings.isNonEmpty((String)commitPropertyTableName)) {
            this.commitPropertyTableName = commitPropertyTableName;
        }
        return this;
    }

    public JaversSqlRepository build() {
        logger.info("starting SqlRepository...");
        logger.info("  dialect:                  {}", (Object)this.dialectName);
        logger.info("  schemaManagementEnabled:  {}", (Object)this.schemaManagementEnabled);
        logger.info("  schema name:              {}", (Object)this.schemaName);
        this.bootContainer();
        SqlRepositoryConfiguration config = new SqlRepositoryConfiguration(this.globalIdCacheDisabled, this.schemaName, this.schemaManagementEnabled, this.globalIdTableName, this.commitTableName, this.snapshotTableName, this.commitPropertyTableName);
        this.addComponent(config);
        PolyJDBC polyJDBC = PolyJDBCBuilder.polyJDBC((Dialect)this.dialectName.getPolyDialect(), (String)config.getSchemaName()).usingManagedConnections(() -> this.connectionProvider.getConnection()).build();
        SessionFactory sessionFactory = new SessionFactory(this.dialectName, this.connectionProvider);
        this.addComponent(polyJDBC);
        this.addComponent(sessionFactory);
        this.addModule(new JaversSqlModule());
        this.addComponent(this.dialectName.getPolyDialect());
        this.addComponent(this.connectionProvider);
        return this.getContainerComponent(JaversSqlRepository.class);
    }

    protected <T> T getContainerComponent(Class<T> ofClass) {
        return (T)super.getContainerComponent(ofClass);
    }
}

