/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.util.Optional;
import org.javers.repository.sql.SqlRepositoryConfiguration;
import org.javers.repository.sql.schema.DBObjectName;

public class TableNameProvider {
    private final Optional<String> schemaName;

    public TableNameProvider(SqlRepositoryConfiguration configuration) {
        this.schemaName = configuration.getSchemaNameAsOptional();
    }

    public String getGlobalIdTableNameWithSchema() {
        return this.getGlobalIdTableName().nameWithSchema();
    }

    public String getCommitTableNameWithSchema() {
        return this.getCommitTableName().nameWithSchema();
    }

    public String getCommitPropertyTableNameWithSchema() {
        return this.getCommitPropertyTableName().nameWithSchema();
    }

    public String getSnapshotTableNameWithSchema() {
        return this.getSnapshotTableName().nameWithSchema();
    }

    public String getSnapshotTablePkSeqWithSchema() {
        return new DBObjectName(this.schemaName, "jv_snapshot_pk_seq").nameWithSchema();
    }

    public String getGlobalIdPkSeqWithSchema() {
        return new DBObjectName(this.schemaName, "jv_global_id_pk_seq").nameWithSchema();
    }

    public String getCommitPkSeqWithSchema() {
        return new DBObjectName(this.schemaName, "jv_commit_pk_seq").nameWithSchema();
    }

    @Deprecated
    public String getCdoClassTableNameWithSchema() {
        return new DBObjectName(this.schemaName, "jv_cdo_class").nameWithSchema();
    }

    public String getSequenceNameWithSchema(String pkColName) {
        return new DBObjectName(this.schemaName, "jv_" + pkColName + "_seq").nameWithSchema();
    }

    DBObjectName getGlobalIdTableName() {
        return new DBObjectName(this.schemaName, "jv_global_id");
    }

    DBObjectName getCommitTableName() {
        return new DBObjectName(this.schemaName, "jv_commit");
    }

    DBObjectName getCommitPropertyTableName() {
        return new DBObjectName(this.schemaName, "jv_commit_property");
    }

    DBObjectName getSnapshotTableName() {
        return new DBObjectName(this.schemaName, "jv_snapshot");
    }
}

