/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import org.javers.common.collections.Optional;
import org.javers.repository.sql.SqlRepositoryConfiguration;
import org.javers.repository.sql.schema.DBObjectName;

public class TableNameProvider {
    private final Optional<String> schemaName;

    public TableNameProvider(SqlRepositoryConfiguration configuration) {
        this.schemaName = configuration.getSchemaNameAsOptional();
    }

    public String getGlobalIdTableNameWithSchema() {
        return this.getGlobalIdTableName().nameWithSchema();
    }

    public DBObjectName getGlobalIdTableName() {
        return new DBObjectName(this.schemaName, "jv_global_id");
    }

    public String getCommitTableNameWithSchema() {
        return this.getCommitTableName().nameWithSchema();
    }

    public DBObjectName getCommitTableName() {
        return new DBObjectName(this.schemaName, "jv_commit");
    }

    public String getCommitPropertyTableNameWithSchema() {
        return this.getCommitPropertyTableName().nameWithSchema();
    }

    public DBObjectName getCommitPropertyTableName() {
        return new DBObjectName(this.schemaName, "jv_commit_property");
    }

    public String getSnapshotTableNameWithSchema() {
        return this.getSnapshotTableName().nameWithSchema();
    }

    public DBObjectName getSnapshotTableName() {
        return new DBObjectName(this.schemaName, "jv_snapshot");
    }

    public String getSnapshotTablePkSeqWithSchema() {
        return new DBObjectName(this.schemaName, "jv_snapshot_pk_seq").nameWithSchema();
    }

    public String getGlobalIdPkSeqWithSchema() {
        return new DBObjectName(this.schemaName, "jv_global_id_pk_seq").nameWithSchema();
    }

    public String getCommitPkSeqWithSchema() {
        return new DBObjectName(this.schemaName, "jv_commit_pk_seq").nameWithSchema();
    }

    @Deprecated
    public String getCdoClassTableNameWithSchema() {
        return new DBObjectName(this.schemaName, "jv_cdo_class").nameWithSchema();
    }

    public String getSequenceNameWithSchema(String pkColName) {
        return new DBObjectName(this.schemaName, "jv_" + pkColName + "_seq").nameWithSchema();
    }
}

