/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.schema.FixedSchemaFactory;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.H2Dialect;
import org.polyjdbc.core.dialect.MsSqlDialect;
import org.polyjdbc.core.dialect.MysqlDialect;
import org.polyjdbc.core.dialect.OracleDialect;
import org.polyjdbc.core.dialect.PostgresDialect;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.util.TheCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSchemaManager
extends SchemaNameAware {
    private static final Logger logger = LoggerFactory.getLogger(JaversSchemaManager.class);
    private SchemaInspector schemaInspector;
    private SchemaManager schemaManager;
    private final Dialect dialect;
    private final FixedSchemaFactory schemaFactory;
    private final PolyJDBC polyJDBC;
    private final ConnectionProvider connectionProvider;

    public JaversSchemaManager(Dialect dialect, FixedSchemaFactory schemaFactory, PolyJDBC polyJDBC, ConnectionProvider connectionProvider, TableNameProvider tableNameProvider) {
        super(tableNameProvider);
        this.dialect = dialect;
        this.schemaFactory = schemaFactory;
        this.polyJDBC = polyJDBC;
        this.connectionProvider = connectionProvider;
    }

    public void ensureSchema() {
        this.schemaInspector = this.polyJDBC.schemaInspector();
        this.schemaManager = this.polyJDBC.schemaManager();
        for (Map.Entry<String, Schema> e : this.schemaFactory.allTablesSchema(this.dialect).entrySet()) {
            this.ensureTable(e.getKey(), e.getValue());
        }
        this.alterCommitIdColumnIfNeeded();
        this.addSnapshotVersionColumnIfNeeded();
        this.addSnapshotManagedTypeColumnIfNeeded();
        this.addGlobalIdTypeNameColumnIfNeeded();
        TheCloser.close((Closeable[])new Closeable[]{this.schemaManager, this.schemaInspector});
    }

    private void alterCommitIdColumnIfNeeded() {
        if (this.getTypeOf(this.getCommitTableNameWithSchema(), "commit_id") == 12) {
            logger.info("migrating db schema from JaVers 1.3.15 to 1.3.16 ...");
            if (this.dialect instanceof PostgresDialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " ALTER COLUMN commit_id TYPE numeric(12,2) USING commit_id::numeric");
            } else if (this.dialect instanceof H2Dialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " ALTER COLUMN commit_id numeric(12,2)");
            } else if (this.dialect instanceof MysqlDialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " MODIFY commit_id numeric(12,2)");
            } else if (this.dialect instanceof OracleDialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " MODIFY commit_id number(12,2)");
            } else if (this.dialect instanceof MsSqlDialect) {
                this.executeSQL("drop index jv_commit_commit_id_idx on " + this.getCommitTableNameWithSchema());
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " ALTER COLUMN commit_id numeric(12,2)");
                this.executeSQL("CREATE INDEX jv_commit_commit_id_idx ON " + this.getCommitTableNameWithSchema() + " (commit_id)");
            } else {
                this.handleUnsupportedDialect();
            }
        }
    }

    private void handleUnsupportedDialect() {
        logger.error("\nno DB schema migration script for {} :(\nplease contact with JaVers team, javers@javers.org", (Object)this.dialect.getCode());
    }

    private void addSnapshotVersionColumnIfNeeded() {
        if (!this.columnExists(this.getSnapshotTableNameWithSchema(), "version")) {
            this.addLongColumn(this.getSnapshotTableNameWithSchema(), "version");
        }
    }

    private void addLongColumn(String tableName, String colName) {
        logger.warn("column " + tableName + "." + colName + " not exists, running ALTER TABLE ...");
        String sqlType = this.dialect.types().bigint(0);
        if (this.dialect instanceof OracleDialect || this.dialect instanceof MsSqlDialect) {
            this.executeSQL("ALTER TABLE " + tableName + " ADD " + colName + " " + sqlType);
        } else {
            this.executeSQL("ALTER TABLE " + tableName + " ADD COLUMN " + colName + " " + sqlType);
        }
    }

    private void addSnapshotManagedTypeColumnIfNeeded() {
        if (!this.columnExists(this.getSnapshotTableNameWithSchema(), "managed_type")) {
            this.addStringColumn(this.getSnapshotTableNameWithSchema(), "managed_type", 200);
            this.populateSnapshotManagedType();
        }
    }

    private void addGlobalIdTypeNameColumnIfNeeded() {
        if (!this.columnExists(this.getGlobalIdTableNameWithSchema(), "type_name")) {
            this.addStringColumn(this.getGlobalIdTableNameWithSchema(), "type_name", 200);
            this.populateGlobalIdTypeName();
        }
    }

    private void populateSnapshotManagedType() {
        String updateStmt = "UPDATE " + this.getSnapshotTableNameWithSchema() + "  SET managed_type = (SELECT qualified_name" + "                      FROM " + this.getCdoClassTableNameWithSchema() + "," + this.getGlobalIdTableNameWithSchema() + "                      WHERE cdo_class_pk = cdo_class_fk " + "                      AND   global_id_pk = global_id_fk" + "                     )";
        int cnt = this.executeUpdate(updateStmt);
        logger.info("populate jv_snapshot.managed_type - " + cnt + " row(s) updated");
    }

    private void populateGlobalIdTypeName() {
        String updateStmt = "UPDATE " + this.getGlobalIdTableNameWithSchema() + "  SET type_name = (SELECT qualified_name" + "                   FROM " + this.getCdoClassTableNameWithSchema() + "                   WHERE cdo_class_pk = cdo_class_fk" + "                   )" + "  WHERE owner_id_fk IS NULL";
        int cnt = this.executeUpdate(updateStmt);
        logger.info("populate jv_global_id.type_name - " + cnt + " row(s) updated");
    }

    private boolean executeSQL(String sql) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            boolean b = stmt.execute(sql);
            stmt.close();
            return b;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int executeUpdate(String sql) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            int cnt = stmt.executeUpdate(sql);
            stmt.close();
            return cnt;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int getTypeOf(String tableName, String colName) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            ResultSet res = stmt.executeQuery("select " + colName + " from " + tableName + " where 1<0");
            int colType = res.getMetaData().getColumnType(1);
            stmt.close();
            res.close();
            return colType;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean columnExists(String tableName, String colName) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            ResultSet res = stmt.executeQuery("select * from " + tableName + " where 1<0");
            ResultSetMetaData metaData = res.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (!metaData.getColumnName(i).equalsIgnoreCase(colName)) continue;
                return true;
            }
            res.close();
            stmt.close();
            return false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureTable(String tableName, Schema schema) {
        if (this.schemaInspector.relationExists(tableName)) {
            return;
        }
        logger.info("creating javers table {} ...", (Object)tableName);
        this.schemaManager.create(schema);
    }

    private void addStringColumn(String tableName, String colName, int len) {
        logger.warn("column " + tableName + "." + colName + " not exists, running ALTER TABLE ...");
        String sqlType = this.dialect.types().string(len);
        if (this.dialect instanceof OracleDialect || this.dialect instanceof MsSqlDialect) {
            this.executeSQL("ALTER TABLE " + tableName + " ADD " + colName + " " + sqlType);
        } else {
            this.executeSQL("ALTER TABLE " + tableName + " ADD COLUMN " + colName + " " + sqlType);
        }
    }

    public void dropSchema() {
        throw new RuntimeException("not implemented");
    }
}

