/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.typeadapter.date.DateTypeCoreAdapters;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.sql.finders.CdoSnapshotDTO;
import org.javers.repository.sql.finders.CommitPropertyDTO;

public class CdoSnapshotsBuilder {
    private JsonConverter jsonConverter;
    private static final String GLOBAL_CDO_ID = "globalId";
    private static final String COMMIT_METADATA = "commitMetadata";
    private static final String STATE_NAME = "state";
    private static final String TYPE_NAME = "type";
    private static final String CHANGED_NAME = "changedProperties";
    private static final String VERSION = "version";

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public List<CdoSnapshot> buildSnapshots(List<CdoSnapshotDTO> snapshotDTOs, List<CommitPropertyDTO> commitPropertyDTOs) {
        final Map<Long, Map<String, String>> commitsProperties = this.convertCommitPropertiesToMap(commitPropertyDTOs);
        return Lists.transform(snapshotDTOs, (Function)new Function<CdoSnapshotDTO, CdoSnapshot>(){

            public CdoSnapshot apply(CdoSnapshotDTO cdoSnapshotDTO) {
                Map commitProperties = (Map)commitsProperties.get(cdoSnapshotDTO.getCommitPK());
                JsonObject json = new JsonObject();
                json.add(CdoSnapshotsBuilder.COMMIT_METADATA, CdoSnapshotsBuilder.this.assembleCommitMetadata(cdoSnapshotDTO, commitProperties));
                json.add(CdoSnapshotsBuilder.STATE_NAME, CdoSnapshotsBuilder.this.jsonConverter.fromJsonToJsonElement(cdoSnapshotDTO.getSnapshotState()));
                json.add(CdoSnapshotsBuilder.CHANGED_NAME, CdoSnapshotsBuilder.this.assembleChangedPropNames(cdoSnapshotDTO));
                json.addProperty(CdoSnapshotsBuilder.TYPE_NAME, cdoSnapshotDTO.getSnapshotType());
                json.addProperty(CdoSnapshotsBuilder.VERSION, (Number)cdoSnapshotDTO.getVersion());
                if (cdoSnapshotDTO.getGlobalId() != null) {
                    json.add(CdoSnapshotsBuilder.GLOBAL_CDO_ID, CdoSnapshotsBuilder.this.jsonConverter.toJsonElement((Object)cdoSnapshotDTO.getGlobalId()));
                } else {
                    json.add(CdoSnapshotsBuilder.GLOBAL_CDO_ID, CdoSnapshotsBuilder.this.assembleGlobalId(cdoSnapshotDTO));
                }
                return (CdoSnapshot)CdoSnapshotsBuilder.this.jsonConverter.fromJson((JsonElement)json, CdoSnapshot.class);
            }
        });
    }

    private Map<Long, Map<String, String>> convertCommitPropertiesToMap(List<CommitPropertyDTO> commitPropertyDTOs) {
        HashMap<Long, Map<String, String>> commitsProperties = new HashMap<Long, Map<String, String>>();
        for (CommitPropertyDTO commitPropertyDTO : commitPropertyDTOs) {
            if (!commitsProperties.containsKey(commitPropertyDTO.getCommitPK())) {
                commitsProperties.put(commitPropertyDTO.getCommitPK(), new HashMap());
            }
            ((Map)commitsProperties.get(commitPropertyDTO.getCommitPK())).put(commitPropertyDTO.getName(), commitPropertyDTO.getValue());
        }
        return commitsProperties;
    }

    private JsonElement assembleChangedPropNames(CdoSnapshotDTO cdoSnapshotDTO) {
        JsonObject jsonObject = new JsonObject();
        String propNamesJSON = cdoSnapshotDTO.getSnapshotChanged();
        if (propNamesJSON == null || propNamesJSON.isEmpty()) {
            return jsonObject;
        }
        return this.jsonConverter.fromJsonToJsonElement(propNamesJSON);
    }

    private JsonElement assembleCommitMetadata(CdoSnapshotDTO snapshotDTO, Map<String, String> commitProperties) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("author", snapshotDTO.getCommitAuthor());
        jsonObject.add("properties", this.jsonConverter.toJsonElement(commitProperties));
        jsonObject.addProperty("commitDate", DateTypeCoreAdapters.serializeToLocal((Date)snapshotDTO.getCommitDate()));
        jsonObject.addProperty("id", (Number)snapshotDTO.getCommitId());
        return jsonObject;
    }

    private JsonElement assembleGlobalId(CdoSnapshotDTO cdoSnapshotDTO) {
        String fragment = cdoSnapshotDTO.getGlobalIdFragment();
        String localIdJSON = cdoSnapshotDTO.getGlobalIdLocalId();
        String cdoType = cdoSnapshotDTO.getSnapshotManagedType();
        String ownerFragment = cdoSnapshotDTO.getOwnerGlobalIdFragment();
        String ownerLocalId = cdoSnapshotDTO.getOwnerGlobalIdLocalId();
        String ownerCdoType = cdoSnapshotDTO.getOwnerGlobalIdTypeName();
        JsonObject json = this.assembleOneGlobalId(cdoType, localIdJSON, fragment);
        if (ownerFragment != null || ownerLocalId != null || ownerCdoType != null) {
            JsonObject ownerId = this.assembleOneGlobalId(ownerCdoType, ownerLocalId, ownerFragment);
            json.add("ownerId", (JsonElement)ownerId);
        }
        return json;
    }

    private JsonObject assembleOneGlobalId(String typeName, String localIdJson, String fragment) {
        JsonObject json = new JsonObject();
        if (localIdJson != null) {
            json.addProperty("entity", typeName);
            json.add("cdoId", this.jsonConverter.fromJsonToJsonElement(localIdJson));
        } else {
            json.addProperty("valueObject", typeName);
            json.addProperty("fragment", fragment);
        }
        return json;
    }
}

