/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Collection;
import org.javers.common.collections.Optional;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.polyjdbc.core.query.SelectQuery;

class SnapshotIdentifiersFilter
extends SnapshotFilter {
    private final Collection<SnapshotIdentifier> snapshotIdentifiers;
    private final GlobalIdRepository globalIdRepository;

    public SnapshotIdentifiersFilter(GlobalIdRepository globalIdRepository, Collection<SnapshotIdentifier> snapshotIdentifiers) {
        this.globalIdRepository = globalIdRepository;
        this.snapshotIdentifiers = snapshotIdentifiers;
    }

    @Override
    String select() {
        return "state, type, version, changed_properties, author, commit_date, commit_id, g.local_id, g.fragment, g.owner_id_fk, g_c.qualified_name, o.local_id owner_local_id, o.fragment owner_fragment, o_c.qualified_name owner_qualified_name";
    }

    @Override
    void addFrom(SelectQuery query) {
        query.from("jv_snapshot INNER JOIN jv_commit ON commit_pk = commit_fk INNER JOIN jv_global_id g ON g.global_id_pk = global_id_fk INNER JOIN jv_cdo_class g_c ON g_c.cdo_class_pk = g.cdo_class_fk LEFT OUTER JOIN jv_global_id o ON o.global_id_pk = g.owner_id_fk LEFT OUTER JOIN jv_cdo_class o_c ON o_c.cdo_class_pk = o.cdo_class_fk");
    }

    @Override
    void addWhere(SelectQuery query) {
        query.where("1!=1");
        for (SnapshotIdentifier snapshotIdentifier : this.snapshotIdentifiers) {
            Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(snapshotIdentifier.getGlobalId());
            if (!globalIdPk.isPresent()) continue;
            query.append(" OR (").append("global_id_fk").append(" = ").append(((Long)globalIdPk.get()).toString()).append(" AND ").append("version").append(" = ").append(Long.toString(snapshotIdentifier.getVersion())).append(")");
        }
    }
}

