/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.javers.core.AbstractJaversBuilder;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.repository.sql.pico.JaversSqlModule;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.PolyJDBCBuilder;
import org.polyjdbc.core.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRepositoryBuilder
extends AbstractJaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlRepositoryBuilder.class);
    private DialectName dialectName;
    private ConnectionProvider connectionProvider;

    public static SqlRepositoryBuilder sqlRepository() {
        return new SqlRepositoryBuilder();
    }

    public SqlRepositoryBuilder withDialect(DialectName dialect) {
        this.dialectName = dialect;
        return this;
    }

    public SqlRepositoryBuilder withConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public JaversSqlRepository build() {
        logger.info("starting up SQL repository module ...");
        this.bootContainer();
        PolyJDBC polyJDBC = PolyJDBCBuilder.polyJDBC((Dialect)this.dialectName.getPolyDialect()).usingManagedConnections(new org.polyjdbc.core.transaction.ConnectionProvider(){

            public Connection getConnection() throws SQLException {
                return SqlRepositoryBuilder.this.connectionProvider.getConnection();
            }
        }).build();
        this.addComponent(polyJDBC);
        this.addModule(new JaversSqlModule());
        this.addComponent(this.dialectName.getPolyDialect());
        this.addComponent(this.connectionProvider);
        return this.getContainerComponent(JaversSqlRepository.class);
    }

    protected <T> T getContainerComponent(Class<T> ofClass) {
        return (T)super.getContainerComponent(ofClass);
    }
}

