/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import org.javers.core.commit.CommitId;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.type.Timestamp;

abstract class SnapshotFilter {
    static final String COMMIT_WITH_SNAPSHOT = "jv_snapshot INNER JOIN jv_commit ON commit_pk = commit_fk";
    static final String COMMIT_WITH_SNAPSHOT_GLOBAL_ID = "jv_snapshot INNER JOIN jv_commit ON commit_pk = commit_fk INNER JOIN jv_global_id g ON g.global_id_pk = global_id_fk INNER JOIN jv_cdo_class g_c ON g_c.cdo_class_pk = g.cdo_class_fk LEFT OUTER JOIN jv_global_id o ON o.global_id_pk = g.owner_id_fk LEFT OUTER JOIN jv_cdo_class o_c ON o_c.cdo_class_pk = o.cdo_class_fk";
    static final String BASE_FIELDS = "state, type, version, changed_properties, author, commit_date, commit_id";
    static final String BASE_AND_GLOBAL_ID_FIELDS = "state, type, version, changed_properties, author, commit_date, commit_id, g.local_id, g.fragment, g.owner_id_fk, g_c.qualified_name, o.local_id owner_local_id, o.fragment owner_fragment, o_c.qualified_name owner_qualified_name";

    SnapshotFilter() {
    }

    abstract String select();

    abstract void addFrom(SelectQuery var1);

    abstract void addWhere(SelectQuery var1);

    void addFromDateCondition(SelectQuery query, LocalDateTime from) {
        query.append(" AND commit_date >= :commitFromDate").withArgument("commitFromDate", (Object)new Timestamp(from.toDate()));
    }

    void addToDateCondition(SelectQuery query, LocalDateTime to) {
        query.append(" AND commit_date <= :commitToDate").withArgument("commitToDate", (Object)new Timestamp(to.toDate()));
    }

    void addCommitIdCondition(SelectQuery query, CommitId commitId) {
        query.append(" AND commit_id = :commitId").withArgument("commitId", (Object)commitId.valueAsNumber());
    }

    void addVersionCondition(SelectQuery query, Long version) {
        query.append(" AND version = :version").withArgument("version", (Object)version);
    }
}

