/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import org.javers.common.collections.Optional;
import org.javers.core.commit.CommitId;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.type.Timestamp;

abstract class SnapshotFilter {
    static final String COMMIT_WITH_SNAPSHOT = "jv_snapshot INNER JOIN jv_commit ON commit_pk = commit_fk";
    static final String BASE_FIELDS = "state, type, version, changed_properties, author, commit_date, commit_id";
    final long primaryKey;
    final String pkFieldName;
    final Optional<String> propertyName;

    public SnapshotFilter(long primaryKey, String pkFieldName, Optional<String> propertyName) {
        this.primaryKey = primaryKey;
        this.pkFieldName = pkFieldName;
        this.propertyName = propertyName;
    }

    void addWhere(SelectQuery query) {
        if (this.propertyName.isPresent()) {
            query.where(this.pkFieldName + " = :pk " + " AND " + "changed_properties" + " like '%\"" + (String)this.propertyName.get() + "\"%'").withArgument("pk", (Object)this.primaryKey);
        } else {
            query.where(this.pkFieldName + " = :pk").withArgument("pk", (Object)this.primaryKey);
        }
    }

    void addFromDateCondition(SelectQuery query, LocalDateTime from) {
        query.append(" AND commit_date >= :commitFromDate").withArgument("commitFromDate", (Object)new Timestamp(from.toDate()));
    }

    void addToDateCondition(SelectQuery query, LocalDateTime to) {
        query.append(" AND commit_date <= :commitToDate").withArgument("commitToDate", (Object)new Timestamp(to.toDate()));
    }

    void addCommitIdCondition(SelectQuery query, CommitId commitId) {
        query.append(" AND commit_id = :commitId").withArgument("commitId", (Object)commitId.valueAsNumber());
    }

    void addVersionCondition(SelectQuery query, Long version) {
        query.append(" AND version = :version").withArgument("version", (Object)version);
    }

    void addFrom(SelectQuery query) {
        query.from(COMMIT_WITH_SNAPSHOT);
    }

    String select() {
        return BASE_FIELDS;
    }
}

