/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.json.GlobalIdRawDTO;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.query.mapper.ObjectMapper;

class CdoSnapshotObjectMapper
implements ObjectMapper<CdoSnapshot> {
    private final Optional<GlobalId> providedGlobalId;
    private final JsonConverter jsonConverter;

    public CdoSnapshotObjectMapper(JsonConverter jsonConverter, Optional<GlobalId> providedGlobalId) {
        this.jsonConverter = jsonConverter;
        this.providedGlobalId = providedGlobalId;
    }

    public CdoSnapshot createObject(ResultSet resultSet) throws SQLException {
        GlobalId usedGlobalId;
        if (this.providedGlobalId.isPresent()) {
            usedGlobalId = (GlobalId)this.providedGlobalId.get();
        } else {
            GlobalIdRawDTO globalIdRawDTO = this.assembleGlobalIdRawDTO(resultSet);
            usedGlobalId = this.jsonConverter.fromDto(globalIdRawDTO);
        }
        CommitMetadata commit = this.assembleCommitMetadata(resultSet);
        CdoSnapshotState state = this.jsonConverter.snapshotStateFromJson(resultSet.getString("state"), usedGlobalId);
        List<String> changedPropNames = this.assembleChangedPropNames(resultSet);
        CdoSnapshotBuilder builder = CdoSnapshotBuilder.cdoSnapshot((GlobalId)usedGlobalId, (CommitMetadata)commit);
        builder.withType(SnapshotType.valueOf((String)resultSet.getString("type")));
        builder.withChangedProperties(changedPropNames);
        return builder.withState(state).build();
    }

    private List<String> assembleChangedPropNames(ResultSet resultSet) throws SQLException {
        String propNamesJSON = resultSet.getString("changed_properties");
        if (propNamesJSON == null || propNamesJSON.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)this.jsonConverter.fromJson(propNamesJSON, List.class);
    }

    private CommitMetadata assembleCommitMetadata(ResultSet resultSet) throws SQLException {
        String author = resultSet.getString("author");
        LocalDateTime commitDate = new LocalDateTime((Object)resultSet.getTimestamp("commit_date"));
        CommitId commitId = CommitId.valueOf((BigDecimal)resultSet.getBigDecimal("commit_id"));
        return new CommitMetadata(author, commitDate, commitId);
    }

    private GlobalIdRawDTO assembleGlobalIdRawDTO(ResultSet resultSet) {
        try {
            String fragment = resultSet.getString("fragment");
            String localIdJSON = resultSet.getString("local_id");
            String cdoClass = resultSet.getString("qualified_name");
            GlobalIdRawDTO ownerId = null;
            if (resultSet.getLong("owner_id_fk") > 0L) {
                String ownerFragment = resultSet.getString("owner_fragment");
                String ownerLocalIdJSON = resultSet.getString("owner_local_id");
                String ownerCdoClass = resultSet.getString("owner_qualified_name");
                ownerId = new GlobalIdRawDTO(ownerCdoClass, ownerLocalIdJSON, ownerFragment, null);
            }
            return new GlobalIdRawDTO(cdoClass, localIdJSON, fragment, ownerId);
        }
        catch (SQLException e) {
            throw new JaversException(JaversExceptionCode.SQL_EXCEPTION, new Object[]{e.getMessage()});
        }
    }
}

