/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.reposiotries;

import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.reposiotries.PersistentGlobalId;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.SelectQuery;

public class GlobalIdRepository {
    private PolyJDBC polyJdbc;
    private JsonConverter jsonConverter;

    public GlobalIdRepository(PolyJDBC javersPolyjdbc) {
        this.polyJdbc = javersPolyjdbc;
    }

    public PersistentGlobalId findPersistedGlobalId(GlobalId globalId) {
        if (globalId instanceof PersistentGlobalId) {
            PersistentGlobalId persistentGlobalId = (PersistentGlobalId)globalId;
            Validate.conditionFulfilled((boolean)persistentGlobalId.persisted(), (String)("unexpected empty persistentGlobalId: " + globalId.value()));
            return persistentGlobalId;
        }
        Optional<Long> globalIdPrimaryKey = this.findGlobalIdPk(globalId);
        return new PersistentGlobalId(globalId, globalIdPrimaryKey);
    }

    public long getOrInsertId(GlobalId globalId) {
        PersistentGlobalId lookup = this.findPersistedGlobalId(globalId);
        return lookup.persisted() ? lookup.getPrimaryKey() : this.insert(globalId);
    }

    public long getOrInsertClass(GlobalId globalId) {
        Class cdoClass = globalId.getCdoClass().getClientsClass();
        Optional<Long> lookup = this.findClassPk(cdoClass);
        return lookup.isPresent() ? ((Long)lookup.get()).longValue() : this.insertClass(cdoClass);
    }

    public Optional<Long> findClassPk(Class<?> cdoClass) {
        SelectQuery query = this.polyJdbc.query().select("cdo_class_pk").from("jv_cdo_class").where("qualified_name = :qualifiedName ").withArgument("qualifiedName", (Object)cdoClass.getName());
        return PolyUtil.queryForOptionalLong(query, this.polyJdbc);
    }

    private Optional<Long> findGlobalIdPk(GlobalId globalId) {
        String GLOBAL_ID_WITH_CDO_CLASS = "jv_global_id as g INNER JOIN jv_cdo_class as c ON cdo_class_pk = cdo_class_fk";
        SelectQuery query = this.polyJdbc.query().select("global_id_pk");
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            PersistentGlobalId ownerFk = this.findPersistedGlobalId(valueObjectId.getOwnerId());
            if (!ownerFk.persisted()) {
                return Optional.empty();
            }
            query.from("jv_global_id").where("fragment = :fragment AND owner_id_fk = :ownerFk ").withArgument("fragment", (Object)valueObjectId.getFragment()).withArgument("ownerFk", (Object)ownerFk.getPrimaryKey());
        } else if (globalId instanceof InstanceId) {
            query.from("jv_global_id as g INNER JOIN jv_cdo_class as c ON cdo_class_pk = cdo_class_fk").where("g.local_id = :localId AND c.qualified_name = :qualifiedName ").withArgument("localId", (Object)this.jsonConverter.toJson(globalId.getCdoId())).withArgument("qualifiedName", (Object)globalId.getCdoClass().getName());
        } else if (globalId instanceof UnboundedValueObjectId) {
            query.from("jv_global_id as g INNER JOIN jv_cdo_class as c ON cdo_class_pk = cdo_class_fk").where("c.qualified_name = :qualifiedName ").withArgument("qualifiedName", (Object)globalId.getCdoClass().getName());
        }
        return PolyUtil.queryForOptionalLong(query, this.polyJdbc);
    }

    private long insert(GlobalId globalId) {
        long classPk = this.getOrInsertClass(globalId);
        InsertQuery query = this.polyJdbc.query().insert().into("jv_global_id");
        query.value("cdo_class_fk", (Object)classPk);
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            long ownerFk = this.getOrInsertId(valueObjectId.getOwnerId());
            query.value("fragment", (Object)valueObjectId.getFragment()).value("owner_id_fk", (Object)ownerFk);
        } else if (globalId instanceof InstanceId) {
            query.value("local_id", (Object)this.jsonConverter.toJson(globalId.getCdoId()));
        }
        query.sequence("global_id_pk", "jv_global_id_pk_seq");
        long globalIdPk = this.polyJdbc.queryRunner().insert(query);
        return globalIdPk;
    }

    private long insertClass(Class<?> cdoClass) {
        InsertQuery query = this.polyJdbc.query().insert().into("jv_cdo_class").value("qualified_name", (Object)cdoClass.getName()).sequence("cdo_class_pk", "jv_cdo_class_pk_seq");
        return this.polyJdbc.queryRunner().insert(query);
    }

    public void setJsonConverter(JsonConverter JSONConverter) {
        this.jsonConverter = JSONConverter;
    }
}

