/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.reposiotries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.repository.sql.PolyUtil;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;
import org.polyjdbc.core.type.Timestamp;

public class CommitMetadataRepository {
    private final PolyJDBC polyJDBC;
    private JsonConverter jsonConverter;

    public CommitMetadataRepository(PolyJDBC polyjdbc) {
        this.polyJDBC = polyjdbc;
    }

    public long save(String author, LocalDateTime date, CommitId commitId) {
        InsertQuery query = this.polyJDBC.query().insert().into("jv_commit").value("author", (Object)author).value("commit_date", (Object)this.toTimestamp(date)).value("commit_id", (Object)commitId.value()).sequence("commit_pk", "jv_commit_pk_seq");
        return this.polyJDBC.queryRunner().insert(query);
    }

    public Optional<Long> getCommitPrimaryKey(Commit commit) {
        SelectQuery selectQuery = this.polyJDBC.query().select("commit_pk").from("jv_commit").where("commit_id = :id").withArgument("id", (Object)commit.getId().value());
        return PolyUtil.queryForOptionalLong(selectQuery, this.polyJDBC);
    }

    private Timestamp toTimestamp(LocalDateTime commitMetadata) {
        return Timestamp.from((Date)commitMetadata.toDate());
    }

    public CommitId getCommitHeadId() {
        Optional<Long> maxPrimaryKey = this.selectMaxCommitPrimaryKey();
        return maxPrimaryKey.isEmpty() ? null : this.selectCommitId((Long)maxPrimaryKey.get());
    }

    private Optional<Long> selectMaxCommitPrimaryKey() {
        SelectQuery query = this.polyJDBC.query().select("MAX(commit_pk)").from("jv_commit");
        Optional<Long> result = PolyUtil.queryForOptionalLong(query, this.polyJDBC);
        if (result.isPresent() && (Long)result.get() == 0L) {
            return Optional.empty();
        }
        return result;
    }

    private CommitId selectCommitId(long primaryKey) {
        SelectQuery query = this.polyJDBC.query().select("commit_id").from("jv_commit").where("commit_pk = :maxPrimaryKey").withArgument("maxPrimaryKey", (Object)primaryKey);
        List commitId = this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)new ObjectMapper<CommitId>(){

            public CommitId createObject(ResultSet resultSet) throws SQLException {
                return (CommitId)CommitMetadataRepository.this.jsonConverter.fromJson(resultSet.getString("commit_id"), CommitId.class);
            }
        });
        if (commitId.size() != 1) {
            throw new JaversException(JaversExceptionCode.CANT_FIND_COMMIT_HEAD_ID, new Object[0]);
        }
        return (CommitId)commitId.get(0);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }
}

