/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.sql.finders.CdoSnapshotFinder;
import org.javers.repository.sql.reposiotries.CdoSnapshotRepository;
import org.javers.repository.sql.reposiotries.CommitMetadataRepository;
import org.javers.repository.sql.reposiotries.GlobalIdRepository;
import org.javers.repository.sql.schema.JaversSchemaManager;

public class JaversSqlRepository
implements JaversRepository {
    private final CommitMetadataRepository commitRepository;
    private final GlobalIdRepository globalIdRepository;
    private final CdoSnapshotRepository cdoSnapshotRepository;
    private final CdoSnapshotFinder finder;
    private final JaversSchemaManager schemaManager;

    public JaversSqlRepository(CommitMetadataRepository commitRepository, GlobalIdRepository globalIdRepository, CdoSnapshotRepository cdoSnapshotRepository, CdoSnapshotFinder finder, JaversSchemaManager schemaManager) {
        this.commitRepository = commitRepository;
        this.globalIdRepository = globalIdRepository;
        this.cdoSnapshotRepository = cdoSnapshotRepository;
        this.finder = finder;
        this.schemaManager = schemaManager;
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, int limit) {
        return this.finder.getStateHistory(globalId, limit);
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.finder.getLatest(globalId);
    }

    public void persist(Commit commit) {
        Optional<Long> primaryKey = this.commitRepository.getCommitPrimaryKey(commit);
        if (primaryKey.isPresent()) {
            throw new JaversException(JaversExceptionCode.CANT_SAVE_ALREADY_PERSISTED_COMMIT, new Object[0]);
        }
        long commitPk = this.commitRepository.save(commit.getAuthor(), commit.getCommitDate(), commit.getId());
        this.cdoSnapshotRepository.save(commitPk, commit.getSnapshots());
    }

    public CommitId getHeadId() {
        return this.commitRepository.getCommitHeadId();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.globalIdRepository.setJsonConverter(jsonConverter);
        this.cdoSnapshotRepository.setJsonConverter(jsonConverter);
        this.finder.setJsonConverter(jsonConverter);
        this.commitRepository.setJsonConverter(jsonConverter);
    }

    public void ensureSchema() {
        this.schemaManager.ensureSchema();
    }
}

