/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.io.Closeable;
import java.util.Map;
import org.javers.repository.sql.schema.FixedSchemaFactory;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.SchemaManagerFactory;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.transaction.TransactionManager;
import org.polyjdbc.core.util.TheCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(JaversSchemaManager.class);
    private FixedSchemaFactory schemaFactory;
    private TransactionManager transactionManager;
    private Dialect dialect;

    public JaversSchemaManager(Dialect dialect, FixedSchemaFactory schemaFactory, TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.schemaFactory = schemaFactory;
        this.dialect = dialect;
    }

    public void ensureSchema() {
        for (Map.Entry<String, Schema> e : this.schemaFactory.allTablesSchema(this.dialect).entrySet()) {
            this.ensureTable(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTable(String tableName, Schema schema) {
        SchemaInspector schemaInspector;
        SchemaManager schemaManager;
        SchemaManagerFactory schemaManagerFactory;
        block3: {
            schemaManagerFactory = new SchemaManagerFactory(this.transactionManager);
            schemaManager = null;
            schemaInspector = null;
            try {
                schemaInspector = schemaManagerFactory.createInspector();
                if (!schemaInspector.relationExists(tableName)) break block3;
            }
            catch (Throwable throwable) {
                TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
                throw throwable;
            }
            TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
            return;
        }
        logger.info("creating javers table {} ...", (Object)tableName);
        schemaManager = schemaManagerFactory.createManager();
        schemaManager.create(schema);
        TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
    }

    public void dropSchema() {
        throw new RuntimeException("not implemented");
    }
}

