/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModels {
    private static final Logger logger = LoggerFactory.getLogger(MetaModels.class);
    Map<String, MetaModel> metaModelsByTableName = new HashMap<String, MetaModel>();
    Map<Class<? extends Model>, MetaModel> metaModelsByClass = new HashMap<Class<? extends Model>, MetaModel>();
    Map<String, MetaModel> metaModelsByClassName = new HashMap<String, MetaModel>();
    private List<Many2ManyAssociation> many2ManyAssociations = new ArrayList<Many2ManyAssociation>();

    void addMetaModel(MetaModel mm, String tableName, Class<? extends Model> modelClass) {
        MetaModel o = this.metaModelsByClass.put(modelClass, mm);
        if (o != null) {
            logger.warn("Double-register: " + modelClass + ": " + o);
        }
        if ((o = this.metaModelsByTableName.put(tableName, mm)) != null) {
            logger.warn("Double-register: " + tableName + ": " + o);
        }
        this.metaModelsByClassName.put(modelClass.getName(), mm);
    }

    MetaModel getMetaModelByClassName(String className) {
        return this.metaModelsByClassName.get(className);
    }

    MetaModel getMetaModel(Class<? extends Model> modelClass) {
        return this.metaModelsByClass.get(modelClass);
    }

    MetaModel getMetaModel(String tableName) {
        MetaModel mm = this.metaModelsByTableName.get(tableName);
        if (mm != null) {
            return mm;
        }
        mm = this.metaModelsByTableName.get(tableName.toLowerCase());
        if (mm != null) {
            return mm;
        }
        return this.metaModelsByTableName.get(tableName.toUpperCase());
    }

    String[] getTableNames(String dbName) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (MetaModel metaModel : this.metaModelsByTableName.values()) {
            if (!metaModel.getDbName().equals(dbName)) continue;
            tableNames.add(metaModel.getTableName());
        }
        return tableNames.toArray(new String[0]);
    }

    Class getModelClass(String tableName) {
        return this.metaModelsByTableName.containsKey(tableName) ? this.metaModelsByTableName.get(tableName).getModelClass() : null;
    }

    String getTableName(Class<? extends Model> modelClass) {
        MetaModel mm = this.metaModelsByClass.get(modelClass);
        return mm == null ? null : mm.getTableName();
    }

    public void setColumnMetadata(String table, Map<String, ColumnMetadata> metaParams) {
        this.metaModelsByTableName.get(table).setColumnMetadata(metaParams);
    }

    protected List<String> getEdges(String join) {
        ArrayList<String> results = new ArrayList<String>();
        if (this.many2ManyAssociations.size() == 0) {
            for (String table : this.metaModelsByTableName.keySet()) {
                MetaModel mm = this.metaModelsByTableName.get(table);
                this.many2ManyAssociations.addAll(mm.getManyToManyAssociations(new ArrayList<Association>()));
            }
        }
        for (Many2ManyAssociation ass : this.many2ManyAssociations) {
            if (!ass.getJoin().equalsIgnoreCase(join)) continue;
            results.add(ass.getSource());
            results.add(ass.getTarget());
        }
        return results;
    }
}

