/*
 * Decompiled with CFR 0.152.
 */
package org.javafunk.excelparser.helper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.function.Consumer;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.javafunk.excelparser.exception.ExcelParsingException;
import org.javafunk.excelparser.helper.Locator;

public class HSSFHelper {
    public static <T> T getCellValue(Sheet sheet, Class<T> type, Integer row, Integer col, boolean zeroIfNull, Consumer<ExcelParsingException> errorHandler) {
        Cell cell = HSSFHelper.getCell(sheet, row, col);
        if (type.equals(String.class)) {
            return (T)HSSFHelper.getStringCell(cell, errorHandler);
        }
        if (type.equals(Date.class)) {
            return (T)(cell == null ? null : HSSFHelper.getDateCell(cell, new Locator(sheet.getSheetName(), row, col), errorHandler));
        }
        if (type.equals(LocalDate.class)) {
            return (T)(cell == null ? null : HSSFHelper.getLocalDateCell(cell, new Locator(sheet.getSheetName(), row, col), errorHandler));
        }
        if (type.equals(LocalDateTime.class)) {
            return (T)(cell == null ? null : HSSFHelper.getLocalDateTimeCell(cell, new Locator(sheet.getSheetName(), row, col), errorHandler));
        }
        if (type.equals(Integer.class)) {
            return (T)HSSFHelper.getIntegerCell(cell, zeroIfNull, new Locator(sheet.getSheetName(), row, col), errorHandler);
        }
        if (type.equals(Double.class)) {
            return (T)HSSFHelper.getDoubleCell(cell, zeroIfNull, new Locator(sheet.getSheetName(), row, col), errorHandler);
        }
        if (type.equals(Long.class)) {
            return (T)HSSFHelper.getLongCell(cell, zeroIfNull, new Locator(sheet.getSheetName(), row, col), errorHandler);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)HSSFHelper.getBigDecimalCell(cell, zeroIfNull, new Locator(sheet.getSheetName(), row, col), errorHandler);
        }
        errorHandler.accept(new ExcelParsingException(MessageFormat.format("{0} data type not supported for parsing", type.getName())));
        return null;
    }

    private static LocalDate getLocalDateCell(Cell cell, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        try {
            if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid date found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
            }
            Instant instant = Instant.ofEpochMilli(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()).getTime());
            LocalDateTime res = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            return res.toLocalDate();
        }
        catch (IllegalStateException illegalStateException) {
            errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid date found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
            return null;
        }
    }

    private static LocalDateTime getLocalDateTimeCell(Cell cell, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        try {
            if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid date found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
            }
            Instant instant = Instant.ofEpochMilli(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()).getTime());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        catch (IllegalStateException illegalStateException) {
            errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid date found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
            return null;
        }
    }

    private static BigDecimal getBigDecimalCell(Cell cell, boolean zeroIfNull, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        String val = HSSFHelper.getStringCell(cell, errorHandler);
        if (val == null || val.trim().equals("")) {
            if (zeroIfNull) {
                return BigDecimal.ZERO;
            }
            return null;
        }
        try {
            return new BigDecimal(val);
        }
        catch (NumberFormatException e) {
            errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid number found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
            if (zeroIfNull) {
                return BigDecimal.ZERO;
            }
            return null;
        }
    }

    static Cell getCell(Sheet sheet, int rowNumber, int columnNumber) {
        Row row = sheet.getRow(rowNumber - 1);
        return row == null ? null : row.getCell(columnNumber - 1);
    }

    static String getStringCell(Cell cell, Consumer<ExcelParsingException> errorHandler) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == 2) {
            int type = cell.getCachedFormulaResultType();
            if (type == 0) {
                DecimalFormat df = new DecimalFormat("###.#");
                return df.format(cell.getNumericCellValue());
            }
            if (type == 5) {
                return "";
            }
            if (type == 1) {
                return cell.getRichStringCellValue().getString().trim();
            }
            if (type == 4) {
                return "" + cell.getBooleanCellValue();
            }
        } else if (cell.getCellType() != 0) {
            return cell.getRichStringCellValue().getString().trim();
        }
        DecimalFormat df = new DecimalFormat("###.#");
        return df.format(cell.getNumericCellValue());
    }

    static Date getDateCell(Cell cell, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        try {
            if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid date found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
            }
            return HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue());
        }
        catch (IllegalStateException illegalStateException) {
            errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid date found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
            return null;
        }
    }

    static Double getDoubleCell(Cell cell, boolean zeroIfNull, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        if (cell == null) {
            return zeroIfNull ? Double.valueOf(0.0) : null;
        }
        if (cell.getCellType() == 0 || cell.getCellType() == 2) {
            return cell.getNumericCellValue();
        }
        if (cell.getCellType() == 3) {
            return zeroIfNull ? Double.valueOf(0.0) : null;
        }
        errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid number found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
        return null;
    }

    static Long getLongCell(Cell cell, boolean zeroIfNull, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        Double doubleValue = HSSFHelper.getNumberWithoutDecimals(cell, zeroIfNull, locator, errorHandler);
        return doubleValue == null ? null : Long.valueOf(doubleValue.longValue());
    }

    static Integer getIntegerCell(Cell cell, boolean zeroIfNull, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        Double doubleValue = HSSFHelper.getNumberWithoutDecimals(cell, zeroIfNull, locator, errorHandler);
        return doubleValue == null ? null : Integer.valueOf(doubleValue.intValue());
    }

    private static Double getNumberWithoutDecimals(Cell cell, boolean zeroIfNull, Locator locator, Consumer<ExcelParsingException> errorHandler) {
        Double doubleValue = HSSFHelper.getDoubleCell(cell, zeroIfNull, locator, errorHandler);
        if (doubleValue != null && doubleValue % 1.0 != 0.0) {
            errorHandler.accept(new ExcelParsingException(MessageFormat.format("Invalid number found in sheet {0} at row {1}, column {2}", locator.getSheetName(), locator.getRow(), locator.getCol())));
        }
        return doubleValue;
    }
}

