/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.orm.hibernate;

import java.lang.reflect.Method;
import java.sql.Connection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.orm.hibernate.FlushableStatelessSession;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class StatelessSessionFactoryBean
implements FactoryBean<FlushableStatelessSession> {
    private final HibernateEntityManagerFactory entityManagerFactory;
    private SessionFactory sessionFactory;

    @Autowired
    public StatelessSessionFactoryBean(HibernateEntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.sessionFactory = entityManagerFactory.getSessionFactory();
    }

    public FlushableStatelessSession getObject() {
        Assert.notNull((Object)this.entityManagerFactory, (String)"Entity manager factory must not be null");
        Assert.notNull((Object)this.sessionFactory, (String)"Session factory must not be null");
        return (FlushableStatelessSession)ProxyFactory.getProxy(FlushableStatelessSession.class, (Interceptor)new StatelessSessionInterceptor((EntityManagerFactory)this.entityManagerFactory, this.sessionFactory));
    }

    public Class<?> getObjectType() {
        return FlushableStatelessSession.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected static final class StatelessSessionSynchronization
    extends TransactionSynchronizationAdapter {
        private static final int ARBITRARY_ORDER_DOWNER = 100;
        private static final int STATELESS_SESSION_SYNCHRONIZATION_ORDER = 800;
        private final SessionFactory sessionFactory;
        private final StatelessSession statelessSession;

        public StatelessSessionSynchronization(SessionFactory sessionFactory, StatelessSession statelessSession) {
            this.sessionFactory = sessionFactory;
            this.statelessSession = statelessSession;
        }

        public int getOrder() {
            return 800;
        }

        public void flush() {
            StatelessSessionInterceptor.flush(this.statelessSession);
        }

        public void beforeCommit(boolean readOnly) {
            if (!readOnly) {
                this.flush();
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.statelessSession.close();
        }
    }

    protected static class StatelessSessionInterceptor
    implements MethodInterceptor {
        private static final String FLUSH_METHOD_NAME = "flush";
        private final EntityManagerFactory entityManagerFactory;
        private final SessionFactory sessionFactory;

        public StatelessSessionInterceptor(EntityManagerFactory entityManagerFactory, SessionFactory sessionFactory) {
            this.entityManagerFactory = entityManagerFactory;
            this.sessionFactory = sessionFactory;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            StatelessSession session = this.getCurrentSession();
            return this.doInvoke(invocation, session);
        }

        private Object doInvoke(MethodInvocation invocation, StatelessSession session) {
            Object result = null;
            if (this.isFlushCalled(invocation)) {
                StatelessSessionInterceptor.flush(session);
            } else {
                result = ReflectionUtils.invokeMethod((Method)invocation.getMethod(), (Object)session, (Object[])invocation.getArguments());
            }
            return result;
        }

        private boolean isFlushCalled(MethodInvocation invocation) {
            return FLUSH_METHOD_NAME.equals(invocation.getMethod().getName());
        }

        private static void flush(StatelessSession session) {
            ((TransactionContext)session).managedFlush();
        }

        private StatelessSession getCurrentSession() {
            Asserts.state(TransactionSynchronizationManager.isActualTransactionActive(), "There should be an active transaction for the current thread.");
            StatelessSession session = (StatelessSession)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
            if (session == null) {
                session = this.openNewStatelessSession();
                this.bindWithTransaction(session);
            }
            return session;
        }

        private StatelessSession openNewStatelessSession() {
            return this.sessionFactory.openStatelessSession(this.getPhysicalConnection());
        }

        private Connection getPhysicalConnection() {
            EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
            SessionImplementor sessionImplementor = (SessionImplementor)entityManager.getDelegate();
            return sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getConnection();
        }

        private void bindWithTransaction(StatelessSession statelessSession) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new StatelessSessionSynchronization(this.sessionFactory, statelessSession));
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)statelessSession);
        }
    }
}

