/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.StringUtils;

public class PropertyReference {
    private static final String PROPERTY_SEPARATOR = ".";
    private final Class<?> beanClass;
    private final String propertyName;

    public PropertyReference(Class<?> beanClass, String propertyName) {
        this.beanClass = Asserts.notNull(beanClass, "Bean class is required");
        this.propertyName = Asserts.hasText(propertyName, "Property name is required");
    }

    public PropertyReference(PropertyReference parent, String propertyName) {
        this(parent.getBeanClass(), parent.getPropertyName() + PROPERTY_SEPARATOR + propertyName);
    }

    public PropertyReference deeper(String propertyName) {
        return new PropertyReference(this, propertyName);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getSimpleName() {
        return this.isNestedProperty() ? StringUtils.substringAfterLast(this.propertyName, PROPERTY_SEPARATOR) : this.propertyName;
    }

    public boolean isNestedProperty() {
        return this.propertyName.contains(PROPERTY_SEPARATOR);
    }

    public PropertyReference getParent() {
        Asserts.state(this.isNestedProperty(), "Can only retrieve the parent for a nested property.");
        String parentName = StringUtils.substringBeforeLast(this.propertyName, PROPERTY_SEPARATOR);
        return new PropertyReference(this.beanClass, parentName);
    }

    public String[] getPath() {
        return this.propertyName.split("\\.");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyReference)) {
            return false;
        }
        PropertyReference other = (PropertyReference)obj;
        return other.getBeanClass().equals(this.beanClass) && other.getPropertyName().equals(this.propertyName);
    }

    public int hashCode() {
        return this.beanClass.hashCode() * this.propertyName.hashCode();
    }

    public String toString() {
        return this.beanClass.getSimpleName() + PROPERTY_SEPARATOR + this.propertyName;
    }
}

