/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.PropertyReference;
import org.springframework.util.ReflectionUtils;

public final class Beans {
    private Beans() {
    }

    public static Set<String> getFieldNames(Class<?> beanClass) {
        final HashSet<String> fieldNames = new HashSet<String>();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalAccessException {
                fieldNames.add(field.getName());
            }
        });
        return fieldNames;
    }

    public static PropertyReference getFinalProperty(PropertyReference propertyReference) {
        if (propertyReference.isNestedProperty()) {
            Class<?> parentType = Beans.findPropertyField(propertyReference.getParent()).getType();
            propertyReference = new PropertyReference(parentType, propertyReference.getSimpleName());
        }
        return propertyReference;
    }

    public static Field findPropertyField(PropertyReference propertyReference) {
        PropertyReference finalReference = Beans.getFinalProperty(propertyReference);
        Field field = ReflectionUtils.findField(finalReference.getBeanClass(), (String)finalReference.getPropertyName());
        return Asserts.notNull(field, "Could not find field '" + finalReference.getPropertyName() + "' in '" + finalReference.getBeanClass().getName() + "'.");
    }
}

