/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.Beans;
import org.jarbframework.utils.bean.PropertyReference;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class Annotations {
    private Annotations() {
    }

    public static <T extends Annotation> T findAnnotation(Class<?> beanClass, Class<T> annotationType) {
        return (T)AnnotationUtils.findAnnotation(beanClass, annotationType);
    }

    public static boolean hasAnnotation(Class<?> beanClass, Class<? extends Annotation> annotationType) {
        return Annotations.findAnnotation(beanClass, annotationType) != null;
    }

    public static <T extends Annotation> T findAnnotation(PropertyReference propertyReference, Class<T> annotationType) {
        Collection<T> annotations = Annotations.getAnnotations(propertyReference, annotationType);
        if (annotations.isEmpty()) {
            return null;
        }
        Asserts.state(annotations.size() == 1, "Found more than one matching annotation.");
        return (T)((Annotation)annotations.iterator().next());
    }

    public static <T extends Annotation> Collection<T> getAnnotations(PropertyReference propertyReference, Class<T> annotationType) {
        PropertyReference finalReference = Beans.getFinalProperty(propertyReference);
        HashSet annotations = new HashSet();
        Annotations.addIfNotNull(annotations, Annotations.getFieldAnnotation(finalReference, annotationType));
        Annotations.addIfNotNull(annotations, Annotations.getGetterAnnotation(finalReference, annotationType));
        return annotations;
    }

    private static <T extends Annotation> T getGetterAnnotation(PropertyReference propertyReference, Class<T> annotationType) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(propertyReference.getBeanClass(), (String)propertyReference.getPropertyName());
        Annotation annotation = null;
        if (propertyDescriptor != null && propertyDescriptor.getReadMethod() != null) {
            annotation = AnnotationUtils.findAnnotation((Method)propertyDescriptor.getReadMethod(), annotationType);
        }
        return (T)annotation;
    }

    private static <T extends Annotation> T getFieldAnnotation(PropertyReference propertyReference, Class<T> annotationType) {
        Field field = ReflectionUtils.findField(propertyReference.getBeanClass(), (String)propertyReference.getPropertyName());
        T annotation = null;
        if (field != null) {
            annotation = field.getAnnotation(annotationType);
        }
        return annotation;
    }

    private static <T> void addIfNotNull(Collection<T> collection, T element) {
        if (element != null) {
            collection.add(element);
        }
    }

    public static boolean hasAnnotation(PropertyReference propertyReference, Class<? extends Annotation> annotationType) {
        return Annotations.findAnnotation(propertyReference, annotationType) != null;
    }
}

