/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jarbframework.utils.JdbcConnectionCallback;
import org.jarbframework.utils.JdbcUtils;

public final class DatabaseProduct {
    public final String databaseName;
    public final String version;

    public DatabaseProduct(String name, String version) {
        this.databaseName = name;
        this.version = version;
    }

    public String getName() {
        return this.databaseName;
    }

    public String getVersion() {
        return this.version;
    }

    public static DatabaseProduct fromDataSource(DataSource dataSource) {
        return JdbcUtils.doWithConnection(dataSource, new JdbcConnectionCallback<DatabaseProduct>(){

            @Override
            public DatabaseProduct doWork(Connection connection) throws SQLException {
                DatabaseMetaData metaData = connection.getMetaData();
                String productName = metaData.getDatabaseProductName();
                String productVersion = metaData.getDatabaseProductVersion();
                return new DatabaseProduct(productName, productVersion);
            }
        });
    }
}

