/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.report.internal.html.table;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jacoco.cli.internal.core.analysis.CounterComparator;
import org.jacoco.cli.internal.core.analysis.ICounter;
import org.jacoco.cli.internal.core.analysis.ICoverageNode;
import org.jacoco.cli.internal.report.internal.ReportOutputFolder;
import org.jacoco.cli.internal.report.internal.html.HTMLElement;
import org.jacoco.cli.internal.report.internal.html.resources.Resources;
import org.jacoco.cli.internal.report.internal.html.table.IColumnRenderer;
import org.jacoco.cli.internal.report.internal.html.table.ITableItem;
import org.jacoco.cli.internal.report.internal.html.table.TableItemComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PercentageColumn
implements IColumnRenderer {
    private final ICoverageNode.CounterEntity entity;
    private final NumberFormat percentageFormat;
    private final Comparator<ITableItem> comparator;

    public PercentageColumn(ICoverageNode.CounterEntity entity, Locale locale) {
        this.entity = entity;
        this.percentageFormat = NumberFormat.getPercentInstance(locale);
        this.comparator = new TableItemComparator(CounterComparator.MISSEDRATIO.on(entity));
    }

    @Override
    public boolean init(List<? extends ITableItem> items, ICoverageNode total) {
        return true;
    }

    @Override
    public void footer(HTMLElement td, ICoverageNode total, Resources resources, ReportOutputFolder base) throws IOException {
        this.cell(td, total);
    }

    @Override
    public void item(HTMLElement td, ITableItem item, Resources resources, ReportOutputFolder base) throws IOException {
        this.cell(td, item.getNode());
    }

    private void cell(HTMLElement td, ICoverageNode node) throws IOException {
        ICounter counter = node.getCounter(this.entity);
        int total = counter.getTotalCount();
        if (total == 0) {
            td.text("n/a");
        } else {
            td.text(this.format(counter.getCoveredRatio()));
        }
    }

    private String format(double ratio) {
        return this.percentageFormat.format(BigDecimal.valueOf(ratio).setScale(2, RoundingMode.FLOOR));
    }

    @Override
    public Comparator<ITableItem> getComparator() {
        return this.comparator;
    }
}

