/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import java.util.HashSet;
import java.util.List;
import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.LabelNode;
import org.jacoco.cli.internal.asm.tree.LineNumberNode;
import org.jacoco.cli.internal.asm.tree.LookupSwitchInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.asm.tree.TableSwitchInsnNode;
import org.jacoco.cli.internal.asm.tree.TypeInsnNode;
import org.jacoco.cli.internal.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilter;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterContext;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;

final class ExhaustiveSwitchFilter
implements IFilter {
    ExhaustiveSwitchFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        int line = -1;
        for (AbstractInsnNode i : methodNode.instructions) {
            if (i.getType() == 15) {
                line = ((LineNumberNode)i).line;
            }
            matcher.match(i, line, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(AbstractInsnNode start, int line, IFilterOutput output) {
            List<LabelNode> labels;
            LabelNode dflt;
            if (start.getOpcode() == 171) {
                dflt = ((LookupSwitchInsnNode)start).dflt;
                labels = ((LookupSwitchInsnNode)start).labels;
            } else if (start.getOpcode() == 170) {
                dflt = ((TableSwitchInsnNode)start).dflt;
                labels = ((TableSwitchInsnNode)start).labels;
            } else {
                return;
            }
            this.cursor = Matcher.skipToLineNumberOrInstruction(dflt);
            if (this.cursor == null) {
                return;
            }
            if (this.cursor.getType() == 15) {
                if (line != ((LineNumberNode)this.cursor).line) {
                    return;
                }
                this.cursor = Matcher.skipNonOpcodes(this.cursor);
            }
            if (this.cursor == null || this.cursor.getOpcode() != 187) {
                return;
            }
            if ("java/lang/MatchException".equals(((TypeInsnNode)this.cursor).desc)) {
                this.nextIs(89);
                this.nextIs(1);
                this.nextIs(1);
                this.nextIsInvoke(183, "java/lang/MatchException", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V");
            } else if ("java/lang/IncompatibleClassChangeError".equals(((TypeInsnNode)this.cursor).desc)) {
                this.nextIs(89);
                this.nextIsInvoke(183, "java/lang/IncompatibleClassChangeError", "<init>", "()V");
            } else {
                return;
            }
            this.nextIs(191);
            if (this.cursor == null) {
                return;
            }
            output.ignore(dflt, this.cursor);
            HashSet<AbstractInsnNode> replacements = new HashSet<AbstractInsnNode>();
            for (LabelNode label : labels) {
                replacements.add(Matcher.skipNonOpcodes(label));
            }
            output.replaceBranches(start, replacements);
        }

        private static AbstractInsnNode skipToLineNumberOrInstruction(AbstractInsnNode cursor) {
            while (cursor != null && (cursor.getType() == 14 || cursor.getType() == 8)) {
                cursor = cursor.getNext();
            }
            return cursor;
        }
    }
}

