/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jacoco.cli.internal.Command;
import org.jacoco.cli.internal.args4j.Argument;
import org.jacoco.cli.internal.args4j.Option;
import org.jacoco.cli.internal.core.analysis.Analyzer;
import org.jacoco.cli.internal.core.analysis.CoverageBuilder;
import org.jacoco.cli.internal.core.analysis.IBundleCoverage;
import org.jacoco.cli.internal.core.analysis.IClassCoverage;
import org.jacoco.cli.internal.core.data.ExecutionDataStore;
import org.jacoco.cli.internal.core.tools.ExecFileLoader;
import org.jacoco.cli.internal.report.DirectorySourceFileLocator;
import org.jacoco.cli.internal.report.FileMultiReportOutput;
import org.jacoco.cli.internal.report.IReportVisitor;
import org.jacoco.cli.internal.report.ISourceFileLocator;
import org.jacoco.cli.internal.report.MultiReportVisitor;
import org.jacoco.cli.internal.report.MultiSourceFileLocator;
import org.jacoco.cli.internal.report.csv.CSVFormatter;
import org.jacoco.cli.internal.report.html.HTMLFormatter;
import org.jacoco.cli.internal.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report
extends Command {
    @Argument(usage="list of JaCoCo *.exec files to read", metaVar="<execfiles>")
    List<File> execfiles = new ArrayList<File>();
    @Option(name="--classfiles", usage="location of Java class files", metaVar="<path>", required=true)
    List<File> classfiles = new ArrayList<File>();
    @Option(name="--sourcefiles", usage="location of the source files", metaVar="<path>")
    List<File> sourcefiles = new ArrayList<File>();
    @Option(name="--tabwith", usage="tab stop width for the source pages (default 4)", metaVar="<n>")
    int tabwidth = 4;
    @Option(name="--name", usage="name used for this report", metaVar="<name>")
    String name = "JaCoCo Coverage Report";
    @Option(name="--encoding", usage="source file encoding (by default platform encoding is used)", metaVar="<charset>")
    String encoding;
    @Option(name="--xml", usage="output file for the XML report", metaVar="<file>")
    File xml;
    @Option(name="--csv", usage="output file for the CSV report", metaVar="<file>")
    File csv;
    @Option(name="--html", usage="output directory for the HTML report", metaVar="<dir>")
    File html;

    @Override
    public String description() {
        return "Generate reports in different formats by reading exec and Java class files.";
    }

    @Override
    public int execute(PrintWriter out, PrintWriter err) throws IOException {
        ExecFileLoader loader = this.loadExecutionData(out);
        IBundleCoverage bundle = this.analyze(loader.getExecutionDataStore(), out);
        this.writeReports(bundle, loader, out);
        return 0;
    }

    private ExecFileLoader loadExecutionData(PrintWriter out) throws IOException {
        ExecFileLoader loader = new ExecFileLoader();
        if (this.execfiles.isEmpty()) {
            out.println("[WARN] No execution data files provided.");
        } else {
            for (File file : this.execfiles) {
                out.printf("[INFO] Loading execution data file %s.%n", file.getAbsolutePath());
                loader.load(file);
            }
        }
        return loader;
    }

    private IBundleCoverage analyze(ExecutionDataStore data, PrintWriter out) throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(data, builder);
        for (File f : this.classfiles) {
            analyzer.analyzeAll(f);
        }
        this.printNoMatchWarning(builder.getNoMatchClasses(), out);
        return builder.getBundle(this.name);
    }

    private void printNoMatchWarning(Collection<IClassCoverage> nomatch, PrintWriter out) {
        if (!nomatch.isEmpty()) {
            out.println("[WARN] Some classes do not match with execution data.");
            out.println("[WARN] For report generation the same class files must be used as at runtime.");
            for (IClassCoverage c : nomatch) {
                out.printf("[WARN] Execution data for class %s does not match.%n", c.getName());
            }
        }
    }

    private void writeReports(IBundleCoverage bundle, ExecFileLoader loader, PrintWriter out) throws IOException {
        out.printf("[INFO] Analyzing %s classes.%n", bundle.getClassCounter().getTotalCount());
        IReportVisitor visitor = this.createReportVisitor();
        visitor.visitInfo(loader.getSessionInfoStore().getInfos(), loader.getExecutionDataStore().getContents());
        visitor.visitBundle(bundle, this.getSourceLocator());
        visitor.visitEnd();
    }

    private IReportVisitor createReportVisitor() throws IOException {
        Object formatter;
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        if (this.xml != null) {
            formatter = new XMLFormatter();
            visitors.add(((XMLFormatter)formatter).createVisitor(new FileOutputStream(this.xml)));
        }
        if (this.csv != null) {
            formatter = new CSVFormatter();
            visitors.add(((CSVFormatter)formatter).createVisitor(new FileOutputStream(this.csv)));
        }
        if (this.html != null) {
            formatter = new HTMLFormatter();
            visitors.add(((HTMLFormatter)formatter).createVisitor(new FileMultiReportOutput(this.html)));
        }
        return new MultiReportVisitor((List<IReportVisitor>)visitors);
    }

    private ISourceFileLocator getSourceLocator() {
        MultiSourceFileLocator multi = new MultiSourceFileLocator(this.tabwidth);
        for (File f : this.sourcefiles) {
            multi.add(new DirectorySourceFileLocator(f, this.encoding, this.tabwidth));
        }
        return multi;
    }
}

