/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_0e20598.core.internal.instr;

import org.jacoco.agent.rt.internal_0e20598.asm.AnnotationVisitor;
import org.jacoco.agent.rt.internal_0e20598.asm.Label;
import org.jacoco.agent.rt.internal_0e20598.asm.MethodVisitor;
import org.jacoco.agent.rt.internal_0e20598.asm.Opcodes;
import org.jacoco.agent.rt.internal_0e20598.asm.Type;
import org.jacoco.agent.rt.internal_0e20598.asm.TypePath;
import org.jacoco.agent.rt.internal_0e20598.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt.internal_0e20598.core.internal.instr.IProbeInserter;
import org.jacoco.agent.rt.internal_0e20598.core.internal.instr.InstrSupport;

class ProbeInserter
extends MethodVisitor
implements IProbeInserter {
    private final IProbeArrayStrategy arrayStrategy;
    private final boolean clinit;
    private final int variable;
    private final Label beginLabel;
    private int accessorStackSize;

    ProbeInserter(int access, String name, String desc, MethodVisitor mv, IProbeArrayStrategy arrayStrategy) {
        super(589824, mv);
        this.clinit = "<clinit>".equals(name);
        this.arrayStrategy = arrayStrategy;
        int pos = (8 & access) == 0 ? 1 : 0;
        for (Type t : Type.getArgumentTypes(desc)) {
            pos += t.getSize();
        }
        this.variable = pos + 1;
        this.beginLabel = new Label();
    }

    public void insertProbe(int id) {
        this.mv.visitVarInsn(25, this.variable);
        InstrSupport.push(this.mv, id);
        this.mv.visitInsn(4);
        this.mv.visitInsn(84);
    }

    public void visitCode() {
        this.mv.visitLabel(this.beginLabel);
        this.accessorStackSize = this.arrayStrategy.storeInstance(this.mv, this.clinit, this.variable);
        this.mv.visitCode();
    }

    public final void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, this.map(var));
    }

    public final void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.map(var), increment);
    }

    public final void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index < this.variable - 1) {
            this.mv.visitLocalVariable(name, desc, signature, this.beginLabel, end, index);
        } else {
            this.mv.visitLocalVariable(name, desc, signature, start, end, this.map(index));
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        int[] newIndex = new int[index.length];
        for (int i = 0; i < newIndex.length; ++i) {
            newIndex[i] = this.map(index[i]);
        }
        return this.mv.visitLocalVariableAnnotation(typeRef, typePath, start, end, newIndex, descriptor, visible);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        int increasedStack = Math.max(maxStack + 3, this.accessorStackSize);
        this.mv.visitMaxs(increasedStack, maxLocals + 2);
    }

    private int map(int var) {
        if (var < this.variable - 1) {
            return var;
        }
        return var + 2;
    }

    public final void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        boolean safetySlotOccupied;
        int pos;
        Object t;
        if (type != -1) {
            throw new IllegalArgumentException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        Object[] newLocal = new Object[Math.max(nLocal + 2, this.variable + 1)];
        int idx = 0;
        int newIdx = 0;
        for (pos = 0; idx < nLocal && pos < this.variable - 1; pos += t == Opcodes.LONG || t == Opcodes.DOUBLE ? 2 : 1) {
            t = local[idx++];
            newLocal[newIdx++] = t;
        }
        boolean bl = safetySlotOccupied = pos == this.variable;
        while (pos < this.variable) {
            newLocal[newIdx++] = Opcodes.TOP;
            ++pos;
        }
        newLocal[newIdx++] = "[Z";
        if (idx < nLocal && safetySlotOccupied) {
            newLocal[newIdx++] = Opcodes.TOP;
        }
        while (idx < nLocal) {
            newLocal[newIdx++] = local[idx++];
        }
        this.mv.visitFrame(type, newIdx, newLocal, nStack, stack);
    }
}

