/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import okhttp3.OkHttpClient;
import org.influxdb.InfluxDB;
import org.influxdb.impl.InfluxDBImpl;

public enum InfluxDBFactory {
    INSTANCE;


    public static InfluxDB connect(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"The URL may not be null or empty.");
        return new InfluxDBImpl(url, null, null, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, String username, String password) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"The URL may not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0, (Object)"The username may not be null or empty.");
        return new InfluxDBImpl(url, username, password, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, OkHttpClient.Builder client) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"The URL may not be null or empty.");
        Preconditions.checkNotNull((Object)client, (Object)"The client may not be null.");
        return new InfluxDBImpl(url, null, null, client);
    }

    public static InfluxDB connect(String url, String username, String password, OkHttpClient.Builder client) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"The URL may not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0, (Object)"The username may not be null or empty.");
        Preconditions.checkNotNull((Object)client, (Object)"The client may not be null.");
        return new InfluxDBImpl(url, username, password, client);
    }
}

