/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public interface InfluxDB {
    public InfluxDB setLogLevel(LogLevel var1);

    public InfluxDB enableGzip();

    public InfluxDB disableGzip();

    public boolean isGzipEnabled();

    public InfluxDB enableBatch(int var1, int var2, TimeUnit var3);

    public InfluxDB enableBatch(int var1, int var2, TimeUnit var3, ThreadFactory var4);

    public void disableBatch();

    public boolean isBatchEnabled();

    public Pong ping();

    public String version();

    public void write(String var1, String var2, Point var3);

    public void write(int var1, Point var2);

    public void write(BatchPoints var1);

    public void write(String var1, String var2, ConsistencyLevel var3, String var4);

    public void write(String var1, String var2, ConsistencyLevel var3, List<String> var4);

    public void write(int var1, String var2);

    public void write(int var1, List<String> var2);

    public QueryResult query(Query var1);

    public QueryResult query(Query var1, TimeUnit var2);

    public void createDatabase(String var1);

    public void deleteDatabase(String var1);

    public List<String> describeDatabases();

    public void close();

    public static enum ConsistencyLevel {
        ALL("all"),
        ANY("any"),
        ONE("one"),
        QUORUM("quorum");

        private final String value;

        private ConsistencyLevel(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum LogLevel {
        NONE,
        BASIC,
        HEADERS,
        FULL;

    }
}

