/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.impl.BatchProcessor;
import org.influxdb.impl.InfluxDBService;
import org.influxdb.impl.TimeUtil;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class InfluxDBImpl
implements InfluxDB {
    static final MediaType MEDIA_TYPE_STRING = MediaType.parse((String)"text/plain");
    private final String username;
    private final String password;
    private final Retrofit retrofit;
    private final InfluxDBService influxDBService;
    private BatchProcessor batchProcessor;
    private final AtomicBoolean batchEnabled = new AtomicBoolean(false);
    private final AtomicLong writeCount = new AtomicLong();
    private final AtomicLong unBatchedCount = new AtomicLong();
    private final AtomicLong batchedCount = new AtomicLong();
    private final HttpLoggingInterceptor loggingInterceptor;
    private InfluxDB.LogLevel logLevel = InfluxDB.LogLevel.NONE;

    public InfluxDBImpl(String url, String username, String password, OkHttpClient.Builder client) {
        this.username = username;
        this.password = password;
        this.loggingInterceptor = new HttpLoggingInterceptor();
        this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        this.retrofit = new Retrofit.Builder().baseUrl(url).client(client.addInterceptor((Interceptor)this.loggingInterceptor).build()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).build();
        this.influxDBService = (InfluxDBService)this.retrofit.create(InfluxDBService.class);
    }

    @Override
    public InfluxDB setLogLevel(InfluxDB.LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
                break;
            }
            case BASIC: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                break;
            }
            case HEADERS: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                break;
            }
            case FULL: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                break;
            }
        }
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit) {
        if (this.batchEnabled.get()) {
            throw new IllegalArgumentException("BatchProcessing is already enabled.");
        }
        this.batchProcessor = BatchProcessor.builder(this).actions(actions).interval(flushDuration, flushDurationTimeUnit).build();
        this.batchEnabled.set(true);
        return this;
    }

    @Override
    public void disableBatch() {
        this.batchEnabled.set(false);
        this.batchProcessor.flush();
        if (this.logLevel != InfluxDB.LogLevel.NONE) {
            System.out.println("total writes:" + this.writeCount.get() + " unbatched:" + this.unBatchedCount.get() + "batchPoints:" + this.batchedCount);
        }
    }

    @Override
    public boolean isBatchEnabled() {
        return this.batchEnabled.get();
    }

    @Override
    public Pong ping() {
        Stopwatch watch = Stopwatch.createStarted();
        Call<ResponseBody> call = this.influxDBService.ping();
        try {
            Response response = call.execute();
            Headers headers = response.headers();
            String version = "unknown";
            for (String name : headers.toMultimap().keySet()) {
                if (null == name || !name.equalsIgnoreCase("X-Influxdb-Version")) continue;
                version = headers.get(name);
            }
            Pong pong = new Pong();
            pong.setVersion(version);
            pong.setResponseTime(watch.elapsed(TimeUnit.MILLISECONDS));
            return pong;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String version() {
        return this.ping().getVersion();
    }

    @Override
    public void write(String database, String retentionPolicy, Point point) {
        if (this.batchEnabled.get()) {
            BatchProcessor.BatchEntry batchEntry = new BatchProcessor.BatchEntry(point, database, retentionPolicy);
            this.batchProcessor.put(batchEntry);
        } else {
            BatchPoints batchPoints = BatchPoints.database(database).retentionPolicy(retentionPolicy).build();
            batchPoints.point(point);
            this.write(batchPoints);
            this.unBatchedCount.incrementAndGet();
        }
        this.writeCount.incrementAndGet();
    }

    @Override
    public void write(BatchPoints batchPoints) {
        this.batchedCount.addAndGet(batchPoints.getPoints().size());
        RequestBody lineProtocol = RequestBody.create((MediaType)MEDIA_TYPE_STRING, (String)batchPoints.lineProtocol());
        this.execute(this.influxDBService.writePoints(this.username, this.password, batchPoints.getDatabase(), batchPoints.getRetentionPolicy(), TimeUtil.toTimePrecision(TimeUnit.NANOSECONDS), batchPoints.getConsistency().value(), lineProtocol));
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, String records) {
        this.execute(this.influxDBService.writePoints(this.username, this.password, database, retentionPolicy, TimeUtil.toTimePrecision(TimeUnit.NANOSECONDS), consistency.value(), RequestBody.create((MediaType)MEDIA_TYPE_STRING, (String)records)));
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, List<String> records) {
        String joinedRecords = Joiner.on((String)"\n").join(records);
        this.write(database, retentionPolicy, consistency, joinedRecords);
    }

    @Override
    public QueryResult query(Query query) {
        Call<QueryResult> call = query.requiresPost() ? this.influxDBService.postQuery(this.username, this.password, query.getDatabase(), query.getCommand()) : this.influxDBService.query(this.username, this.password, query.getDatabase(), query.getCommand());
        return this.execute(call);
    }

    @Override
    public QueryResult query(Query query, TimeUnit timeUnit) {
        return this.execute(this.influxDBService.query(this.username, this.password, query.getDatabase(), TimeUtil.toTimePrecision(timeUnit), query.getCommand()));
    }

    @Override
    public void createDatabase(String name) {
        Preconditions.checkArgument((!name.contains("-") ? 1 : 0) != 0, (Object)"Database name cant contain -");
        String createDatabaseQueryString = String.format("CREATE DATABASE \"%s\"", name);
        if (this.version().startsWith("0.")) {
            createDatabaseQueryString = String.format("CREATE DATABASE IF NOT EXISTS \"%s\"", name);
        }
        this.execute(this.influxDBService.postQuery(this.username, this.password, createDatabaseQueryString));
    }

    @Override
    public void deleteDatabase(String name) {
        this.execute(this.influxDBService.postQuery(this.username, this.password, "DROP DATABASE \"" + name + "\""));
    }

    @Override
    public List<String> describeDatabases() {
        QueryResult result = this.execute(this.influxDBService.query(this.username, this.password, "SHOW DATABASES"));
        List<List<Object>> databaseNames = result.getResults().get(0).getSeries().get(0).getValues();
        ArrayList databases = Lists.newArrayList();
        if (databaseNames != null) {
            for (List<Object> database : databaseNames) {
                databases.add(database.get(0).toString());
            }
        }
        return databases;
    }

    private <T> T execute(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            ResponseBody errorBody = response.errorBody();
            Throwable throwable = null;
            try {
                try {
                    throw new RuntimeException(errorBody.string());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (errorBody != null) {
                    if (throwable != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        errorBody.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

