/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.influxdb.dto.ContinuousQuery;
import org.influxdb.dto.Database;
import org.influxdb.dto.DatabaseConfiguration;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Serie;
import org.influxdb.dto.Server;
import org.influxdb.dto.Shard;
import org.influxdb.dto.ShardSpace;
import org.influxdb.dto.Shards;
import org.influxdb.dto.User;

public interface InfluxDB {
    public InfluxDB setLogLevel(LogLevel var1);

    public Pong ping();

    public String version();

    public void write(String var1, TimeUnit var2, Serie ... var3);

    public void writeUdp(int var1, TimeUnit var2, Serie ... var3);

    public List<Serie> query(String var1, String var2, TimeUnit var3);

    public void createDatabase(String var1);

    public void createDatabase(DatabaseConfiguration var1);

    public void deleteDatabase(String var1);

    public List<Database> describeDatabases();

    public void createClusterAdmin(String var1, String var2);

    public void deleteClusterAdmin(String var1);

    public List<User> describeClusterAdmins();

    public void updateClusterAdmin(String var1, String var2);

    public void createDatabaseUser(String var1, String var2, String var3, String ... var4);

    public void deleteDatabaseUser(String var1, String var2);

    public List<User> describeDatabaseUsers(String var1);

    public void updateDatabaseUser(String var1, String var2, String var3, String ... var4);

    public void alterDatabasePrivilege(String var1, String var2, boolean var3, String ... var4);

    public void authenticateDatabaseUser(String var1, String var2, String var3);

    public List<ContinuousQuery> describeContinuousQueries(String var1);

    public void deleteContinuousQuery(String var1, int var2);

    public void deleteSeries(String var1, String var2);

    public void forceRaftCompaction();

    public List<String> interfaces();

    public Boolean sync();

    public List<Server> listServers();

    public void removeServers(int var1);

    @Deprecated
    public void createShard(Shard var1);

    @Deprecated
    public Shards getShards();

    @Deprecated
    public void dropShard(Shard var1);

    public List<ShardSpace> getShardSpaces();

    public void dropShardSpace(String var1, String var2);

    public void createShardSpace(String var1, ShardSpace var2);

    public static enum LogLevel {
        NONE,
        BASIC,
        HEADERS,
        FULL;

    }
}

