/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SerializabilityTestSupport {
    private Serializable object;

    protected abstract Serializable instance() throws Exception;

    @Before
    public final void initializeHarness() throws Exception {
        this.object = this.instance();
        Assert.assertNotNull((String)"instance() returned null", (Object)this.object);
    }

    @Test
    public final void shouldSerializeAndDeserializeWithoutErrorPreservingFields() {
        byte[] serialized = SerializationUtils.serialize((Serializable)this.object);
        Serializable deserialized = (Serializable)SerializationUtils.deserialize((byte[])serialized);
        this.checkThawedObject(this.object, deserialized);
    }

    protected void checkThawedObject(Serializable expected, Serializable actual) {
        Assert.assertEquals((String)"thawed object comparison", (Object)expected, (Object)actual);
    }
}

