/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class EqualsHashCodeTestSupport {
    private static final int NUMBER_OF_ITERATIONS = 20;
    protected Object firstEqual;
    protected Object secondEqual;
    protected Object thirdEqual;
    protected Object notEqual;

    protected abstract Object equal() throws Exception;

    protected abstract Object notEqual() throws Exception;

    @Before
    public final void initializeHarness() throws Exception {
        this.firstEqual = this.equal();
        this.secondEqual = this.equal();
        this.thirdEqual = this.equal();
        this.notEqual = this.notEqual();
        Assert.assertNotNull((String)"equal() returned null", (Object)this.firstEqual);
        Assert.assertNotNull((String)"2nd equal() returned null", (Object)this.secondEqual);
        Assert.assertNotNull((String)"3rd equal() returned null", (Object)this.thirdEqual);
        Assert.assertNotNull((String)"notEqual() returned null", (Object)this.notEqual);
        Assert.assertNotSame((Object)this.firstEqual, (Object)this.secondEqual);
        Assert.assertNotSame((Object)this.firstEqual, (Object)this.thirdEqual);
        Assert.assertNotSame((Object)this.firstEqual, (Object)this.notEqual);
        Assert.assertNotSame((Object)this.secondEqual, (Object)this.thirdEqual);
        Assert.assertNotSame((Object)this.secondEqual, (Object)this.notEqual);
        Assert.assertNotSame((Object)this.thirdEqual, (Object)this.notEqual);
        Assert.assertEquals((String)"1st and 2nd equal instances of different classes", this.firstEqual.getClass(), this.secondEqual.getClass());
        Assert.assertEquals((String)"1st and 3rd equal instances of different classes", this.firstEqual.getClass(), this.thirdEqual.getClass());
        Assert.assertEquals((String)"1st equal instance and not-equal instance of different classes", this.firstEqual.getClass(), this.notEqual.getClass());
    }

    @Test
    public final void shouldNotBeEqualToJavaLangObject() {
        Object o = new Object();
        EqualsHashCodeTestSupport.assertNotEquals(this.firstEqual, o);
        EqualsHashCodeTestSupport.assertNotEquals(this.secondEqual, o);
        EqualsHashCodeTestSupport.assertNotEquals(this.thirdEqual, o);
        EqualsHashCodeTestSupport.assertNotEquals(this.notEqual, o);
    }

    @Test
    public final void shouldNotBeEqualToNull() {
        EqualsHashCodeTestSupport.assertNotEquals("1st vs. null", this.firstEqual, null);
        EqualsHashCodeTestSupport.assertNotEquals("2nd vs. null", this.secondEqual, null);
        EqualsHashCodeTestSupport.assertNotEquals("3rd vs. null", this.thirdEqual, null);
        EqualsHashCodeTestSupport.assertNotEquals("not-equal vs. null", this.notEqual, null);
    }

    @Test
    public final void unequalObjectsShouldNotCompareEqual() {
        EqualsHashCodeTestSupport.assertNotEquals("1st vs. not-equal", this.firstEqual, this.notEqual);
        EqualsHashCodeTestSupport.assertNotEquals("2nd vs. not-equal", this.secondEqual, this.notEqual);
        EqualsHashCodeTestSupport.assertNotEquals("3rd vs. not-equal", this.thirdEqual, this.notEqual);
        EqualsHashCodeTestSupport.assertNotEquals("not-equal vs. 1st", this.notEqual, this.firstEqual);
        EqualsHashCodeTestSupport.assertNotEquals("not-equal vs. 2nd", this.notEqual, this.secondEqual);
        EqualsHashCodeTestSupport.assertNotEquals("not-equal vs. 3rd", this.notEqual, this.thirdEqual);
    }

    @Test
    public final void equalsShouldBeConsistentAcrossInvocations() {
        for (int i = 0; i < 20; ++i) {
            this.shouldNotBeEqualToJavaLangObject();
            this.shouldNotBeEqualToNull();
            this.unequalObjectsShouldNotCompareEqual();
            this.equalsShouldBeReflexive();
            this.equalsShouldBeSymmetricAndTransitive();
        }
    }

    @Test
    public final void equalsShouldBeReflexive() {
        Assert.assertEquals((String)"1st equal instance", (Object)this.firstEqual, (Object)this.firstEqual);
        Assert.assertEquals((String)"2nd equal instance", (Object)this.secondEqual, (Object)this.secondEqual);
        Assert.assertEquals((String)"3rd equal instance", (Object)this.thirdEqual, (Object)this.thirdEqual);
        Assert.assertEquals((String)"not-equal instance", (Object)this.notEqual, (Object)this.notEqual);
    }

    @Test
    public final void equalsShouldBeSymmetricAndTransitive() {
        Assert.assertEquals((String)"1st vs. 2nd", (Object)this.firstEqual, (Object)this.secondEqual);
        Assert.assertEquals((String)"2nd vs. 1st", (Object)this.secondEqual, (Object)this.firstEqual);
        Assert.assertEquals((String)"1st vs. 3rd", (Object)this.firstEqual, (Object)this.thirdEqual);
        Assert.assertEquals((String)"3rd vs. 1st", (Object)this.thirdEqual, (Object)this.firstEqual);
        Assert.assertEquals((String)"2nd vs. 3rd", (Object)this.secondEqual, (Object)this.thirdEqual);
        Assert.assertEquals((String)"3rd vs. 2nd", (Object)this.thirdEqual, (Object)this.secondEqual);
    }

    @Test
    public final void equalObjectsShouldGiveSameHashCode() {
        Assert.assertEquals((String)"1st vs. 2nd", (long)this.firstEqual.hashCode(), (long)this.secondEqual.hashCode());
        Assert.assertEquals((String)"1st vs. 3rd", (long)this.firstEqual.hashCode(), (long)this.thirdEqual.hashCode());
        Assert.assertEquals((String)"2nd vs. 3rd", (long)this.secondEqual.hashCode(), (long)this.thirdEqual.hashCode());
    }

    @Test
    public final void hashCodeShouldBeConsistentAcrossInvocations() {
        int firstHash = this.firstEqual.hashCode();
        int secondHash = this.secondEqual.hashCode();
        int thirdHash = this.thirdEqual.hashCode();
        int notEqualHash = this.notEqual.hashCode();
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((String)"1st equal instance", (long)firstHash, (long)this.firstEqual.hashCode());
            Assert.assertEquals((String)"2nd equal instance", (long)secondHash, (long)this.secondEqual.hashCode());
            Assert.assertEquals((String)"3rd equal instance", (long)thirdHash, (long)this.thirdEqual.hashCode());
            Assert.assertEquals((String)"not-equal instance", (long)notEqualHash, (long)this.notEqual.hashCode());
        }
    }

    private static void assertNotEquals(Object expected, Object actual) {
        EqualsHashCodeTestSupport.assertNotEquals(null, expected, actual);
    }

    protected static void assertNotEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            EqualsHashCodeTestSupport.failNotEquals(message, expected);
        }
    }

    private static void failNotEquals(String message, Object expected) {
        String formatted = "";
        if (message != null) {
            formatted = message + ' ';
        }
        Assert.fail((String)(formatted + "expected not equals to: <" + expected + '>'));
    }
}

